/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaSearchVocabulariesMethodCheck
extends BaseFileCheck {
    private static final Pattern _searchVocabulariesPattern = Pattern.compile("\\w+\\.searchVocabularies\\(");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!fileName.endsWith(".java")) {
            return content;
        }
        String newContent = content;
        boolean failedValidation = false;
        boolean replaced = false;
        Matcher matcher = _searchVocabulariesPattern.matcher(content);
        while (matcher.find()) {
            List<String> parameterList;
            String methodCall = JavaSourceUtil.getMethodCall(content, matcher.start());
            if (!this.hasClassOrVariableName("AssetVocabularyService", content, content, methodCall) && !this.hasClassOrVariableName("AssetVocabularyLocalService", content, content, methodCall) || (parameterList = JavaSourceUtil.getParameterList(methodCall)).size() != 5) continue;
            String[] parameterTypes = new String[]{"long", "long", "String", "int", "int"};
            if (!this.hasParameterTypes(content, content, ArrayUtil.toStringArray(parameterList), parameterTypes)) {
                failedValidation = true;
                continue;
            }
            String newMethod = this._addOrReplaceParameters(matcher.group(0), methodCall, parameterList);
            newContent = StringUtil.replace(newContent, methodCall, newMethod);
            replaced = true;
        }
        if (replaced) {
            newContent = JavaSourceUtil.addImports(newContent, "com.liferay.portal.kernel.search.Sort");
        }
        if (failedValidation) {
            this.addMessage(fileName, StringBundler.concat("Could not resolve types of searchVocabularies method. ", "The method signature has changed to searchVocabularies(", "long companyId, long[] groupIds, String title, int[] ", "visibilityTypes, int start, int end, Sort sort). Fill ", "the new parameters manually."));
        }
        return newContent;
    }

    private String _addOrReplaceParameters(String group, String methodCall, List<String> parameterList) {
        parameterList.add(3, "new int[]{}");
        parameterList.add(6, "new Sort()");
        parameterList.set(1, StringBundler.concat("new long[]{", parameterList.get(1), "}"));
        StringBundler sb = new StringBundler(3);
        sb.append(group);
        sb.append(StringUtil.merge(parameterList, ", "));
        sb.append(")");
        return StringUtil.replace(methodCall, methodCall, sb.toString());
    }
}

