/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.comparator.ElementComparator;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLTestIgnorableErrorLinesFileCheck
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.endsWith("/test-ignorable-error-lines.xml")) {
            this._checkTestIgnorableErrorLinesXml(fileName, content);
        }
        return content;
    }

    private void _checkTestIgnorableErrorLinesXml(String fileName, String content) {
        Document document = SourceUtil.readXML(content);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        List javascriptElements = rootElement.elements("javascript");
        for (Element javascriptElement : javascriptElements) {
            this.checkElementOrder(fileName, javascriptElement, "ignore-error", null, new ElementComparator("description"));
        }
        List logElements = rootElement.elements("log");
        for (Element logElement : logElements) {
            this.checkElementOrder(fileName, logElement, "ignore-error", null, new ElementComparator("description"));
        }
    }
}

