/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.util;

import com.liferay.poshi.core.PoshiProperties;
import com.liferay.poshi.core.util.GetterUtil;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.core.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class PropsUtil {
    private static final Set<String> _upperCaseTerms = new HashSet<String>(){
        {
            this.add("csv");
            this.add("url");
        }
    };

    public static void clear() {
        PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
        poshiProperties.clear();
        PropsUtil._setProperties(PropsUtil._getClassProperties());
    }

    public static String get(String key) {
        PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
        String value = poshiProperties.getProperty(key);
        if (Validator.isNull(value)) {
            value = System.getProperty(key);
        }
        return value;
    }

    public static String getEnvironmentVariable(String name) {
        return System.getenv(name);
    }

    public static Properties getProperties() {
        return PoshiProperties.getPoshiProperties();
    }

    public static void set(String key, String value) {
        block10: {
            PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
            poshiProperties.setProperty(key, value);
            if (poshiProperties.debugStacktrace.booleanValue()) {
                System.out.println("Setting property \"" + key + "\" to: " + value);
            }
            Class<?> poshiPropertiesClass = poshiProperties.getClass();
            try {
                String[] objectValue = value;
                Field field = poshiPropertiesClass.getField(PropsUtil._toCamelCase(key));
                Class<?> fieldType = field.getType();
                String fieldTypeName = fieldType.getName();
                if (fieldTypeName.equals("boolean") || fieldTypeName.equals("java.lang.Boolean")) {
                    objectValue = GetterUtil.getBoolean(value);
                } else if (fieldTypeName.equals("int") || fieldTypeName.equals("java.lang.Integer")) {
                    objectValue = GetterUtil.getInteger(value);
                } else if (fieldType.isArray()) {
                    objectValue = StringUtil.split(value);
                }
                field.set(poshiProperties, objectValue);
            }
            catch (IllegalAccessException illegalAccessException) {
                if (poshiProperties.debugStacktrace.booleanValue()) {
                    System.out.println("Unable to set field " + PropsUtil._toCamelCase(key));
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (!poshiProperties.debugStacktrace.booleanValue()) break block10;
                System.out.println("Field " + PropsUtil._toCamelCase(key) + " does not exist");
            }
        }
    }

    public static void setProperties(Properties properties) {
        PropsUtil._setProperties(properties);
        PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
        poshiProperties.printProperties(true);
    }

    private static Properties _getClassProperties() {
        String[] propertiesFileNames;
        Properties classProperties = new Properties();
        for (String propertiesFileName : propertiesFileNames = new String[]{"poshi.properties", "poshi-ext.properties"}) {
            Class<PropsUtil> clazz = PropsUtil.class;
            ClassLoader classLoader = clazz.getClassLoader();
            InputStream inputStream = classLoader.getResourceAsStream(propertiesFileName);
            if (inputStream == null) continue;
            try {
                classProperties.load(inputStream);
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
        return classProperties;
    }

    private static void _setProperties(Properties properties) {
        for (String propertyName : properties.stringPropertyNames()) {
            String propertyValue = properties.getProperty(propertyName);
            if (propertyValue == null) continue;
            PropsUtil.set(propertyName, propertyValue);
        }
    }

    private static String _toCamelCase(String propertyName) {
        String[] terms = propertyName.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < terms.length; ++i) {
            String term = terms[i];
            if (i != 0) {
                term = _upperCaseTerms.contains(term) ? StringUtil.upperCase(term) : StringUtil.capitalize(term);
            }
            sb.append(term);
        }
        return sb.toString();
    }
}

