/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.check.util.BNDSourceUtil;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.JavaVariable;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaAnnotationsCheck
extends BaseJavaTermCheck {
    private static final Pattern _annotationLineBreakPattern1 = Pattern.compile("[{=]\n.*(\" \\+\n\t*\")");
    private static final Pattern _arrayPattern = Pattern.compile("=\\s+\\{");
    private static final Pattern _classConstantPattern = Pattern.compile("^([A-Z]\\w+)\\.?([A-Z]\\w+)$");
    private static final Pattern _componentNamePattern = Pattern.compile("component\\.name=(.+?\\.[A-Z]\\w*)");
    private static final Pattern _pipePattern = Pattern.compile("(= \".*)( \\| | \\||\\| )");
    private volatile Map<String, String> _bundleSymbolicNamesMap;
    private final Map<String, JavaClass> _javaClassMap = new ConcurrentHashMap<String, JavaClass>();
    private volatile String _rootDirName;

    protected void checkComponentName(String fileName, String absolutePath, JavaClass javaClass, String annotation, String attributeValue, boolean forceOSGiComponent) throws Exception {
        String componentName = this._getComponentName(absolutePath, javaClass, attributeValue);
        if (componentName == null) {
            return;
        }
        if (componentName.contains("+")) {
            componentName = componentName.replaceAll("[^\\w\\.]", "");
        }
        if (componentName.contains("*")) {
            this.addMessage(fileName, "Do not use globs for the 'component.name'. Use the fully qualified name of the component class.");
            return;
        }
        if (!componentName.startsWith("com.liferay") || !forceOSGiComponent) {
            return;
        }
        JavaClass componentJavaClass = this._getJavaClass(absolutePath, componentName);
        if (componentJavaClass != null) {
            List<String> importNames = componentJavaClass.getImportNames();
            if (componentJavaClass.hasAnnotation("Component") && importNames.contains("org.osgi.service.component.annotations.Component")) {
                return;
            }
        }
        this.addMessage(fileName, "The value '" + componentName + "' is not a valid OSGi component");
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws Exception {
        return this.formatAnnotations(fileName, absolutePath, (JavaClass)javaTerm, fileContent);
    }

    protected String formatAnnotation(String fileName, String absolutePath, JavaClass javaClass, String fileContent, String annotation, String indent) throws Exception {
        if (!annotation.contains("(")) {
            return annotation;
        }
        annotation = this._fixAnnotationLineBreaks(annotation);
        annotation = this._fixSingleValueArray(annotation);
        annotation = this._fixWhitespaceAroundPipe(annotation);
        return annotation;
    }

    protected String formatAnnotations(String fileName, String absolutePath, JavaClass javaClass, String fileContent) throws Exception {
        String content = javaClass.getContent();
        if (javaClass.getParentJavaClass() != null) {
            return content;
        }
        List<String> annotationsBlocks = SourceUtil.getAnnotationsBlocks(content);
        for (String annotationsBlock : annotationsBlocks) {
            String indent = SourceUtil.getIndent(annotationsBlock);
            String newAnnotationsBlock = this._formatAnnotations(fileName, absolutePath, javaClass, fileContent, annotationsBlock, indent);
            content = StringUtil.replace(content, "\n" + annotationsBlock, "\n" + newAnnotationsBlock);
        }
        return content;
    }

    protected String getAnnotationAttributeValue(String annotation, String attributeName) {
        int start;
        Pattern pattern = Pattern.compile("[^\\w\"]" + attributeName + "\\s*=");
        Matcher matcher = pattern.matcher(annotation);
        if (!matcher.find()) {
            return null;
        }
        int end = start = matcher.end() + 1;
        do {
            if ((end = annotation.indexOf(44, end + 1)) != -1) continue;
            end = annotation.lastIndexOf(41);
            break;
        } while (ToolsUtil.isInsideQuotes(annotation, end) || this.getLevel(annotation.substring(start, end), "{", "}") != 0);
        String attributeValue = StringUtil.trim(annotation.substring(start, end));
        if (!attributeValue.contains("\n")) {
            return attributeValue;
        }
        return StringUtil.replace(attributeValue, new String[]{"\t", ",\n", "\n"}, new String[]{"", ", ", ""});
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private String _fixAnnotationLineBreaks(String annotation) {
        Matcher matcher = _annotationLineBreakPattern1.matcher(annotation);
        if (matcher.find()) {
            return StringUtil.replaceFirst(annotation, matcher.group(1), "", matcher.start());
        }
        return annotation;
    }

    private String _fixSingleValueArray(String annotation) {
        Matcher matcher = _arrayPattern.matcher(annotation);
        block0: while (matcher.find()) {
            int x = matcher.start();
            if (ToolsUtil.isInsideQuotes(annotation, x)) continue;
            String arrayString = null;
            int y = x;
            do {
                if ((y = annotation.indexOf("}", y + 1)) != -1) continue;
                return annotation;
            } while (ToolsUtil.isInsideQuotes(annotation, y) || this.getLevel(arrayString = annotation.substring(matcher.end() - 1, y + 1), "{", "}") != 0);
            y = -1;
            while ((y = arrayString.indexOf(",", y + 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(arrayString, y)) continue;
                continue block0;
            }
            String replacement = StringUtil.trim(arrayString.substring(1, arrayString.length() - 1));
            if (!Validator.isNotNull(replacement)) continue;
            return StringUtil.replace(annotation, arrayString, replacement);
        }
        return annotation;
    }

    private String _fixWhitespaceAroundPipe(String annotation) {
        Matcher matcher = _pipePattern.matcher(annotation);
        return matcher.replaceFirst("$1|");
    }

    private String _formatAnnotations(String fileName, String absolutePath, JavaClass javaClass, String fileContent, String annotationsBlock, String indent) throws Exception {
        List<String> annotations = SourceUtil.splitAnnotations(annotationsBlock, indent);
        for (String annotation : annotations) {
            String newAnnotation = this.formatAnnotation(fileName, absolutePath, javaClass, fileContent, annotation, indent);
            if (newAnnotation.contains("(")) {
                newAnnotation = this._formatAnnotations(fileName, absolutePath, javaClass, fileContent, newAnnotation, indent + "\t\t");
            }
            annotationsBlock = StringUtil.replace(annotationsBlock, annotation, newAnnotation);
        }
        return annotationsBlock;
    }

    private Map<String, String> _getBundleSymbolicNamesMap(String absolutePath) {
        Map<String, String> bundleSymbolicNamesMap = this._bundleSymbolicNamesMap;
        if (bundleSymbolicNamesMap == null) {
            this._bundleSymbolicNamesMap = bundleSymbolicNamesMap = BNDSourceUtil.getBundleSymbolicNamesMap(this._getRootDirName(absolutePath));
        }
        return bundleSymbolicNamesMap;
    }

    private String _getComponentName(String absolutePath, JavaClass javaClass, String attributeValue) throws Exception {
        Matcher classConstantMatcher = _classConstantPattern.matcher(attributeValue);
        if (!classConstantMatcher.find()) {
            Matcher componentNameMatcher = _componentNamePattern.matcher(attributeValue);
            if (componentNameMatcher.find()) {
                return componentNameMatcher.group(1);
            }
            return null;
        }
        String classConstantName = classConstantMatcher.group(1);
        JavaClass classConstantJavaClass = javaClass;
        if (classConstantMatcher.groupCount() == 2) {
            String className = classConstantMatcher.group(1);
            String fullyQualifiedName = javaClass.getPackageName() + "." + className;
            for (String importName : javaClass.getImportNames()) {
                if (!importName.endsWith(className)) continue;
                fullyQualifiedName = importName;
                break;
            }
            classConstantName = classConstantMatcher.group(2);
            classConstantJavaClass = this._getJavaClass(absolutePath, fullyQualifiedName);
        }
        if (classConstantJavaClass != null) {
            for (JavaTerm javaTerm : classConstantJavaClass.getChildJavaTerms()) {
                JavaVariable javaVariable;
                if (!javaTerm.isJavaVariable() || !classConstantName.equals((javaVariable = (JavaVariable)javaTerm).getName())) continue;
                Matcher componentNameMatcher = _componentNamePattern.matcher(javaVariable.getContent());
                if (componentNameMatcher.find()) {
                    return componentNameMatcher.group(1);
                }
                return null;
            }
        }
        return null;
    }

    private JavaClass _getJavaClass(String absolutePath, String fullyQualifiedName) throws Exception {
        File javaFile;
        JavaClass javaClass = this._javaClassMap.get(fullyQualifiedName);
        if (javaClass == null && (javaFile = JavaSourceUtil.getJavaFile(fullyQualifiedName, this._getRootDirName(absolutePath), this._getBundleSymbolicNamesMap(absolutePath))) != null) {
            javaClass = JavaClassParser.parseJavaClass(javaFile.getName(), FileUtil.read(javaFile));
            this._javaClassMap.put(fullyQualifiedName, javaClass);
        }
        return javaClass;
    }

    private String _getRootDirName(String absolutePath) {
        String rootDirName = this._rootDirName;
        if (rootDirName == null) {
            this._rootDirName = rootDirName = JavaSourceUtil.getRootDirName(absolutePath);
        }
        return rootDirName;
    }
}

