/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.JavaAnnotationsCheck;
import com.liferay.source.formatter.parser.JavaClass;
import java.util.List;

public class JavaInjectAnnotationsCheck
extends JavaAnnotationsCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String formatAnnotation(String fileName, String absolutePath, JavaClass javaClass, String fileContent, String annotation, String indent) throws Exception {
        if (!absolutePath.contains("/test/") && !absolutePath.contains("/testIntegration/")) {
            return annotation;
        }
        String trimmedAnnotation = StringUtil.trim(annotation);
        if (!trimmedAnnotation.equals("@Inject") && !trimmedAnnotation.startsWith("@Inject(")) {
            return annotation;
        }
        List<String> importNames = javaClass.getImportNames();
        if (!importNames.contains("com.liferay.portal.test.rule.Inject")) {
            return annotation;
        }
        this._checkFilterAttribute(fileName, absolutePath, javaClass, annotation, "filter");
        return annotation;
    }

    private void _checkFilterAttribute(String fileName, String absolutePath, JavaClass javaClass, String annotation, String filterAttribute) throws Exception {
        String filterAttributeValue = this.getAnnotationAttributeValue(annotation, filterAttribute);
        if (filterAttributeValue == null) {
            return;
        }
        this.checkComponentName(fileName, absolutePath, javaClass, annotation, filterAttributeValue, false);
    }
}

