/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeGetPortletGroupIdMethodCheck
extends BaseFileCheck {
    private static final Pattern _getPortletGroupIdPattern = Pattern.compile("(\\w+)\\.getPortletGroupId\\(\\)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!(fileName.endsWith(".java") || fileName.endsWith(".jsp") || fileName.endsWith(".jspf") || fileName.endsWith(".ftl"))) {
            return content;
        }
        String newContent = content;
        Matcher matcher = _getPortletGroupIdPattern.matcher(content);
        while (matcher.find()) {
            String methodCall = matcher.group(0);
            String variableName = matcher.group(1);
            if (fileName.endsWith(".java") ? !this.hasClassOrVariableName("ThemeDisplay", newContent, newContent, methodCall) : !variableName.equals("themeDisplay")) continue;
            newContent = StringUtil.replace(newContent, methodCall, StringUtil.replace(methodCall, ".getPortletGroupId()", ".getScopeGroupId()"));
        }
        return newContent;
    }
}

