/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseUpgradeMatcherReplacementCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaExtractTextMethodCheck
extends BaseUpgradeMatcherReplacementCheck {
    @Override
    protected String afterFormat(String fileName, String absolutePath, String content, String newContent) {
        newContent = this.addNewImports(newContent);
        return StringUtil.replaceLast(newContent, '}', "\n\t@Reference\n\tprivate HtmlParser _htmlParser;\n}");
    }

    @Override
    protected String formatMatcherIteration(String content, String newContent, Matcher matcher) {
        String methodCall = JavaSourceUtil.getMethodCall(content, matcher.start());
        return StringUtil.replace(newContent, methodCall, StringUtil.replace(methodCall, "HtmlUtil.extractText(", "_htmlParser.extractText("));
    }

    @Override
    protected String[] getNewImports() {
        return new String[]{"com.liferay.portal.kernel.util.HtmlParser", "org.osgi.service.component.annotations.Reference"};
    }

    @Override
    protected Pattern getPattern() {
        return Pattern.compile("HtmlUtil\\.extractText\\(");
    }
}

