/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.check.BaseAPICheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UpgradeRemovedAPICheck
extends BaseAPICheck {
    private static final String _MSG_CLASS_NOT_FOUND_1 = "class.not.found.1";
    private static final String _MSG_CLASS_NOT_FOUND_2 = "class.not.found.2";
    private static final String _MSG_CLASS_NOT_FOUND_3 = "class.not.found.3";
    private static final String _MSG_CONSTRUCTOR_NOT_FOUND = "constructor.not.found";
    private static final String _MSG_METHOD_NOT_FOUND = "method.not.found";
    private static final String _MSG_VARIABLE_NOT_FOUND = "variable.not.found";

    public int[] getDefaultTokens() {
        return new int[]{14, 154, 15};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null || AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Deprecated")) {
            return;
        }
        String upgradeFromVersion = this.getAttributeValue("upgrade.from.version");
        String upgradeToVersion = this.getAttributeValue("upgrade.to.version");
        try {
            JSONObject upgradeFromJavaClassesJSONObject = this.getJavaClassesJSONObject(upgradeFromVersion);
            JSONObject upgradeToJavaClassesJSONObject = this.getJavaClassesJSONObject(upgradeToVersion);
            List<String> removedImportNames = this._getRemovedImportNames(detailAST, upgradeFromJavaClassesJSONObject, upgradeToJavaClassesJSONObject, upgradeToVersion);
            this._checkRemovedConstructors(detailAST, removedImportNames, upgradeFromJavaClassesJSONObject, upgradeToJavaClassesJSONObject, upgradeToVersion);
            this._checkRemovedMethods(detailAST, removedImportNames, upgradeFromJavaClassesJSONObject, upgradeToJavaClassesJSONObject, upgradeToVersion);
            this._checkRemovedTypes(detailAST, removedImportNames, upgradeFromJavaClassesJSONObject, upgradeToJavaClassesJSONObject, upgradeToVersion);
            this._checkRemovedVariables(detailAST, removedImportNames, upgradeFromJavaClassesJSONObject, upgradeToJavaClassesJSONObject, upgradeToVersion);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void _checkRemovedConstructors(DetailAST detailAST, List<String> removedImportNames, JSONObject upgradeFromJavaClassesJSONObject, JSONObject upgradeToJavaClassesJSONObject, String upgradeToVersion) {
        List<BaseAPICheck.ConstructorCall> constructorCalls = this.getConstructorCalls(detailAST, removedImportNames, false);
        for (BaseAPICheck.ConstructorCall constructorCall : constructorCalls) {
            List<JSONObject> upgradeFromConstructorJSONObjects = this.getConstructorJSONObjects(constructorCall, upgradeFromJavaClassesJSONObject);
            if (upgradeFromConstructorJSONObjects.isEmpty()) continue;
            JSONObject classJSONObject = upgradeToJavaClassesJSONObject.getJSONObject(constructorCall.getTypeName());
            if (classJSONObject == null) {
                this._logRemovedClass(constructorCall.getTypeName(), constructorCall.getLineNumber(), upgradeToVersion, upgradeToJavaClassesJSONObject);
                continue;
            }
            List<JSONObject> upgradeToConstructorJSONObjects = this.getConstructorJSONObjects(constructorCall, upgradeToJavaClassesJSONObject);
            if (!upgradeToConstructorJSONObjects.isEmpty()) continue;
            this.log(constructorCall.getLineNumber(), _MSG_CONSTRUCTOR_NOT_FOUND, new Object[]{constructorCall.getTypeName(), upgradeToVersion});
        }
    }

    private void _checkRemovedMethods(DetailAST detailAST, List<String> removedImportNames, JSONObject upgradeFromJavaClassesJSONObject, JSONObject upgradeToJavaClassesJSONObject, String upgradeToVersion) {
        List<BaseAPICheck.MethodCall> methodCalls = this.getMethodCalls(detailAST, removedImportNames, false);
        for (BaseAPICheck.MethodCall methodCall : methodCalls) {
            List<JSONObject> upgradeFromMethodJSONObjects = this.getMethodJSONObjects(methodCall, upgradeFromJavaClassesJSONObject);
            if (upgradeFromMethodJSONObjects.isEmpty()) continue;
            JSONObject classJSONObject = upgradeToJavaClassesJSONObject.getJSONObject(methodCall.getVariableTypeName());
            if (classJSONObject == null) {
                this._logRemovedClass(methodCall.getVariableTypeName(), methodCall.getLineNumber(), upgradeToVersion, upgradeToJavaClassesJSONObject);
                continue;
            }
            List<JSONObject> upgradeToMethodJSONObjects = this.getMethodJSONObjects(methodCall, upgradeToJavaClassesJSONObject);
            if (!upgradeToMethodJSONObjects.isEmpty()) continue;
            this.log(methodCall.getLineNumber(), _MSG_METHOD_NOT_FOUND, new Object[]{methodCall.getName(), methodCall.getVariableTypeName(), upgradeToVersion});
        }
    }

    private void _checkRemovedTypes(DetailAST detailAST, List<String> removedImportNames, JSONObject upgradeFromJavaClassesJSONObject, JSONObject upgradeToJavaClassesJSONObject, String upgradeToVersion) {
        Map<String, Set<Integer>> typeNamesMap = this.getTypeNamesMap(detailAST, removedImportNames, false);
        for (Map.Entry<String, Set<Integer>> entry : typeNamesMap.entrySet()) {
            String typeName = entry.getKey();
            JSONObject upgradeFromClassJSONObject = upgradeFromJavaClassesJSONObject.getJSONObject(typeName);
            JSONObject upgradeToClassJSONObject = upgradeToJavaClassesJSONObject.getJSONObject(typeName);
            if (upgradeFromClassJSONObject == null || upgradeToClassJSONObject != null) continue;
            Set<Integer> lineNumbers = entry.getValue();
            for (int lineNumber : lineNumbers) {
                this._logRemovedClass(typeName, lineNumber, upgradeToVersion, upgradeToJavaClassesJSONObject);
            }
        }
    }

    private void _checkRemovedVariables(DetailAST detailAST, List<String> removedImportNames, JSONObject upgradeFromJavaClassesJSONObject, JSONObject upgradeToJavaClassesJSONObject, String upgradeToVersion) {
        List<BaseAPICheck.VariableCall> variableCalls = this.getVariableCalls(detailAST, removedImportNames, false);
        for (BaseAPICheck.VariableCall variableCall : variableCalls) {
            JSONObject upgradeFromVariableJSONObject = this.getVariableJSONObject(variableCall, upgradeFromJavaClassesJSONObject);
            if (upgradeFromVariableJSONObject == null) continue;
            JSONObject classJSONObject = upgradeToJavaClassesJSONObject.getJSONObject(variableCall.getTypeName());
            if (classJSONObject == null) {
                this._logRemovedClass(variableCall.getTypeName(), variableCall.getLineNumber(), upgradeToVersion, upgradeToJavaClassesJSONObject);
                continue;
            }
            JSONObject upgradeToVariableJSONObject = this.getVariableJSONObject(variableCall, upgradeToJavaClassesJSONObject);
            if (upgradeToVariableJSONObject != null) continue;
            this.log(variableCall.getLineNumber(), _MSG_VARIABLE_NOT_FOUND, new Object[]{variableCall.getName(), variableCall.getTypeName(), upgradeToVersion});
        }
    }

    private List<String> _getRemovedImportNames(DetailAST detailAST, JSONObject upgradeFromJavaClassesJSONObject, JSONObject upgradeToJavaClassesJSONObject, String upgradeToVersion) {
        ArrayList<String> removedImportNames = new ArrayList<String>();
        List<String> importNames = this.getImportNames(detailAST);
        for (String importName : importNames) {
            JSONObject upgradeFromClassJSONObject = upgradeFromJavaClassesJSONObject.getJSONObject(importName);
            JSONObject upgradeToClassJSONObject = upgradeToJavaClassesJSONObject.getJSONObject(importName);
            if (upgradeFromClassJSONObject == null || upgradeToClassJSONObject != null) continue;
            this._logRemovedClass(importName, detailAST.getLineNo(), upgradeToVersion, upgradeToJavaClassesJSONObject);
            removedImportNames.add(importName);
        }
        return removedImportNames;
    }

    private void _logRemovedClass(String typeName, int lineNumber, String upgradeToVersion, JSONObject upgradeToJavaClassesJSONObject) {
        int x = typeName.lastIndexOf(".");
        String s = typeName.substring(x);
        ArrayList<String> classNames = new ArrayList<String>();
        for (String className : upgradeToJavaClassesJSONObject.keySet()) {
            if (!className.endsWith(s)) continue;
            classNames.add(className);
        }
        if (classNames.isEmpty()) {
            this.log(lineNumber, _MSG_CLASS_NOT_FOUND_1, new Object[]{typeName, upgradeToVersion});
        } else if (classNames.size() == 1) {
            this.log(lineNumber, _MSG_CLASS_NOT_FOUND_2, new Object[]{typeName, upgradeToVersion, classNames.get(0)});
        } else {
            this.log(lineNumber, _MSG_CLASS_NOT_FOUND_3, new Object[]{typeName, upgradeToVersion, StringUtil.merge(classNames, ", ")});
        }
    }
}

