/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.processor;

import com.liferay.source.formatter.SourceFormatterExcludes;
import com.liferay.source.formatter.processor.BaseSourceProcessor;
import com.liferay.source.formatter.util.CETUtil;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class CETSourceProcessor
extends BaseSourceProcessor {
    private static final String _CET_DIR_LOCATION = "/modules/apps/client-extension/client-extension-type-api/src/main/java/com/liferay/client/extension/type";
    private static final String[] _INCLUDES = new String[]{"**/client-extension-type-api/src/main/java/com/liferay/client/extension/type/*.java"};

    @Override
    protected List<String> doGetFileNames() throws IOException {
        return this.getFileNames(new String[0], this.getIncludes());
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    @Override
    protected void postFormat() throws Exception {
        if (!this.isPortalSource()) {
            return;
        }
        List<String> fileNames = this.doGetFileNames();
        if (fileNames.isEmpty()) {
            return;
        }
        String shortFileName = "client-extension-types.json";
        File jsonFile = new File(this.getPortalDir(), "modules/apps/client-extension/client-extension-type-api/src/main/resources/com/liferay/client/extension/type/dependencies/" + shortFileName);
        String oldContent = FileUtil.read(jsonFile);
        List<String> cetFileNames = SourceFormatterUtil.scanForFileNames(this.getPortalDir() + _CET_DIR_LOCATION, new String[0], new String[]{"**/*CET.java"}, new SourceFormatterExcludes(), true);
        String newContent = CETUtil.getJSONContent(cetFileNames);
        if (!oldContent.equals(newContent)) {
            FileUtil.write(jsonFile, newContent);
            System.out.println("Updated '" + shortFileName + "'");
        }
    }
}

