/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.JavaAnnotationsCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;

public class JavaReferenceAnnotationsCheck
extends JavaAnnotationsCheck {
    private static final String _ALLOWED_REFERENCE_METHOD_FILE_NAMES_KEY = "allowedReferenceMethodFileNames";
    private static final String _CHECK_REFERENCE_METHOD_KEY = "checkReferenceMethod";
    private static final String _IGNORE_TARGET_ATTRIBUTE_VALUES_KEY = "ignoreTargetAttributeValues";

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String formatAnnotation(String fileName, String absolutePath, JavaClass javaClass, String fileContent, String annotation, String indent) throws Exception {
        String trimmedAnnotation = StringUtil.trim(annotation);
        if (!trimmedAnnotation.equals("@Reference") && !trimmedAnnotation.startsWith("@Reference(")) {
            return annotation;
        }
        List<String> importNames = javaClass.getImportNames();
        if (!importNames.contains("org.osgi.service.component.annotations.Reference")) {
            return annotation;
        }
        this._checkReferenceMethods(fileName, absolutePath, javaClass);
        this._checkTargetAttribute(fileName, absolutePath, javaClass, annotation, "target");
        return annotation;
    }

    private void _checkReferenceMethods(String fileName, String absolutePath, JavaClass javaClass) {
        if (!this.isAttributeValue(_CHECK_REFERENCE_METHOD_KEY, absolutePath)) {
            return;
        }
        for (String allowedReferenceMethodFileName : this.getAttributeValues(_ALLOWED_REFERENCE_METHOD_FILE_NAMES_KEY, absolutePath)) {
            if (!absolutePath.endsWith(allowedReferenceMethodFileName)) continue;
            return;
        }
        for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
            if (!javaTerm.isJavaMethod() || !javaTerm.hasAnnotation("Reference")) continue;
            this.addMessage(fileName, StringBundler.concat("Do not use @Reference on method ", javaTerm.getName(), ", use @Reference on field or ServiceTracker", "/ServiceTrackerList/ServiceTrackerMap instead"));
        }
    }

    private void _checkTargetAttribute(String fileName, String absolutePath, JavaClass javaClass, String annotation, String targetAttribute) throws Exception {
        String targetAttributeValue = this.getAnnotationAttributeValue(annotation, targetAttribute);
        List<String> ignoreTargetAttributeValues = this.getAttributeValues(_IGNORE_TARGET_ATTRIBUTE_VALUES_KEY, absolutePath);
        if (targetAttributeValue == null || ignoreTargetAttributeValues.contains(targetAttributeValue)) {
            return;
        }
        this.checkComponentName(fileName, absolutePath, javaClass, annotation, targetAttributeValue, true);
    }
}

