/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseUpgradeMatcherReplacementCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeGetImagePreviewURLMethodCheck
extends BaseUpgradeMatcherReplacementCheck {
    @Override
    protected String afterFormat(String fileName, String absolutePath, String content, String newContent) {
        if (fileName.endsWith(".java")) {
            newContent = this.addNewImports(newContent);
            newContent = StringUtil.replaceLast(newContent, '}', "\t@Reference\n\tprivate DLURLHelper _dlURLHelper;\n\n}");
        }
        return newContent;
    }

    @Override
    protected String formatMatcherIteration(String content, String newContent, Matcher matcher) {
        String methodCall = matcher.group();
        return StringUtil.replace(newContent, methodCall, StringUtil.replace(methodCall, "DLUtil", "_dlURLHelper"));
    }

    @Override
    protected String[] getNewImports() {
        return new String[]{"com.liferay.document.library.util.DLURLHelper"};
    }

    @Override
    protected Pattern getPattern() {
        return Pattern.compile("DLUtil\\.\\s*getImagePreviewURL\\(");
    }

    @Override
    protected String[] getValidExtensions() {
        return new String[]{"java", "jsp"};
    }
}

