/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.portal.xml.SAXReaderFactory;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class SourceUtil {
    private static final Pattern _annotationMemberValuePairPattern = Pattern.compile("(\\w+) = (\".*?\"|.*(?=[,\\)\\s]))");
    private static final Pattern _modifierPattern = Pattern.compile("[^\n]\n(\t*)(public|protected|private)");

    public static boolean containsUnquoted(String s, String text) {
        int x = -1;
        do {
            if ((x = s.indexOf(text, x + 1)) != -1) continue;
            return false;
        } while (ToolsUtil.isInsideQuotes(s, x));
        return true;
    }

    public static String getAbsolutePath(File file) {
        return SourceUtil.getAbsolutePath(file.toPath());
    }

    public static String getAbsolutePath(Path filePath) {
        filePath = filePath.toAbsolutePath();
        filePath = filePath.normalize();
        return StringUtil.replace(filePath.toString(), '\\', '/');
    }

    public static String getAbsolutePath(String fileName) {
        return SourceUtil.getAbsolutePath(Paths.get(fileName, new String[0]));
    }

    public static Map<String, String> getAnnotationMemberValuePair(String annotation) {
        HashMap<String, String> annotationMemberValuePair = new HashMap<String, String>();
        Matcher matcher = _annotationMemberValuePairPattern.matcher(annotation);
        while (matcher.find()) {
            annotationMemberValuePair.put(matcher.group(1), StringUtil.unquote(matcher.group(2)));
        }
        return annotationMemberValuePair;
    }

    public static List<String> getAnnotationsBlocks(String content) {
        ArrayList<String> annotationsBlocks = new ArrayList<String>();
        Matcher matcher = _modifierPattern.matcher(content);
        block0: while (matcher.find()) {
            int lineNumber = SourceUtil.getLineNumber(content, matcher.end());
            String annotationsBlock = "";
            int i = lineNumber - 1;
            while (true) {
                String line;
                if (Validator.isNull(line = SourceUtil.getLine(content, i)) || line.matches("\t*(private|public|protected| \\*/).*")) {
                    if (!Validator.isNotNull(annotationsBlock)) continue block0;
                    annotationsBlocks.add(annotationsBlock);
                    continue block0;
                }
                annotationsBlock = line + "\n" + annotationsBlock;
                --i;
            }
        }
        return annotationsBlocks;
    }

    public static String getIndent(String s) {
        StringBundler sb = new StringBundler(s.length());
        for (int i = 0; i < s.length() && s.charAt(i) == '\t'; ++i) {
            sb.append('\t');
        }
        return sb.toString();
    }

    public static String getLine(String content, int lineNumber) {
        int nextLineStartPos = SourceUtil.getLineStartPos(content, lineNumber);
        if (nextLineStartPos == -1) {
            return null;
        }
        int nextLineEndPos = content.indexOf(10, nextLineStartPos);
        if (nextLineEndPos == -1) {
            return content.substring(nextLineStartPos);
        }
        return content.substring(nextLineStartPos, nextLineEndPos);
    }

    public static int getLineNumber(String content, int pos) {
        return StringUtil.count(content, 0, pos, '\n') + 1;
    }

    public static int getLineStartPos(String content, int lineNumber) {
        if (lineNumber <= 0) {
            return -1;
        }
        if (lineNumber == 1) {
            return 0;
        }
        int x = -1;
        for (int i = 1; i < lineNumber; ++i) {
            if ((x = content.indexOf(10, x + 1)) != -1) continue;
            return x;
        }
        return x + 1;
    }

    public static int[] getMultiLinePositions(String content, Pattern multiLinePattern) {
        ArrayList<Integer> multiLinePositions = new ArrayList<Integer>();
        Matcher matcher = multiLinePattern.matcher(content);
        while (matcher.find()) {
            multiLinePositions.add(SourceUtil.getLineNumber(content, matcher.start()));
            multiLinePositions.add(SourceUtil.getLineNumber(content, matcher.end() - 1));
        }
        return ArrayUtil.toIntArray(multiLinePositions);
    }

    public static String getRootDirName(String absolutePath) {
        int x;
        File file;
        do {
            if ((x = absolutePath.lastIndexOf(47)) != -1) continue;
            return "";
        } while (!(file = new File((absolutePath = absolutePath.substring(0, x)) + "/portal-impl")).exists());
        return absolutePath;
    }

    public static boolean hasTypo(String s1, String s2) {
        if (Validator.isNull(s1) || Validator.isNull(s2) || s1.equals(s2) || s1.charAt(0) != s2.charAt(0) || s1.charAt(s1.length() - 1) != s2.charAt(s2.length() - 1)) {
            return false;
        }
        int min = Math.min(s1.length(), s2.length());
        int diff = Math.abs(s1.length() - s2.length());
        if (min < 5 || diff > 1) {
            return false;
        }
        int i = StringUtil.startsWithWeight(s1, s2);
        if ((s1 = s1.substring(i)).startsWith("_")) {
            return false;
        }
        if ((s2 = s2.substring(i)).startsWith("_")) {
            return false;
        }
        int j = 1;
        while (j <= s1.length() && j <= s2.length()) {
            if (s1.charAt(s1.length() - j) != s2.charAt(s2.length() - j)) {
                char[] chars1 = s1.toCharArray();
                char[] chars2 = s2.toCharArray();
                Arrays.sort(chars1);
                Arrays.sort(chars2);
                return Arrays.equals(chars1, chars2);
            }
            ++j;
        }
        return true;
    }

    public static boolean isInsideMultiLines(int lineNumber, int[] multiLinePositions) {
        for (int i = 0; i < multiLinePositions.length - 1; i += 2) {
            if (lineNumber < multiLinePositions[i]) {
                return false;
            }
            if (lineNumber > multiLinePositions[i + 1]) continue;
            return true;
        }
        return false;
    }

    public static boolean isLiteralString(String s) {
        if (s == null || s.length() < 2) {
            return false;
        }
        return s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"';
    }

    public static boolean isXML(String content) {
        return SourceUtil.readXML(content) != null;
    }

    public static Document readXML(File file) {
        SAXReader saxReader = SAXReaderFactory.getSAXReader(null, false, false);
        try {
            return saxReader.read(file);
        }
        catch (DocumentException documentException) {
            return null;
        }
    }

    public static Document readXML(String content) {
        SAXReader saxReader = SAXReaderFactory.getSAXReader(null, false, false);
        try {
            return saxReader.read((Reader)new UnsyncStringReader(content));
        }
        catch (DocumentException documentException) {
            return null;
        }
    }

    public static List<String> splitAnnotations(String annotationsBlock, String indent) throws IOException {
        ArrayList<String> annotations = new ArrayList<String>();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(annotationsBlock));){
            String annotation = null;
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (annotation == null) {
                    if (!line.startsWith(indent + "@")) continue;
                    annotation = line + "\n";
                    continue;
                }
                String lineIndent = SourceUtil.getIndent(line);
                if (lineIndent.length() < indent.length()) {
                    annotations.add(annotation);
                    annotation = null;
                    continue;
                }
                if (line.startsWith(indent + "@")) {
                    annotations.add(annotation);
                    annotation = line + "\n";
                    continue;
                }
                annotation = annotation + line + "\n";
            }
            if (Validator.isNotNull(annotation)) {
                annotations.add(annotation);
            }
        }
        return annotations;
    }
}

