/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.GitUtil;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.processor.SourceProcessor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class CopyrightCheck
extends BaseFileCheck {
    private static final String _XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private static List<String> _currentBranchAddedFileNames;
    private static List<String> _currentBranchRenamedFileNames;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!fileName.endsWith(".tpl") && !fileName.endsWith(".vm")) {
            content = this._fixCopyright(fileName, absolutePath, content);
        }
        return content;
    }

    private String _fixCopyright(String fileName, String absolutePath, String content) throws Exception {
        int x = content.indexOf("/**\n * SPDX-FileCopyrightText: (c) ");
        if (x == -1) {
            this.addMessage(fileName, "Missing copyright");
            return content;
        }
        String s = content.substring(x + 35, content.indexOf("\n", x + 35));
        if (!s.matches("\\d{4} Liferay, Inc\\. https://liferay\\.com")) {
            this.addMessage(fileName, "Missing copyright");
            return content;
        }
        if (!(content.startsWith("/**\n * SPDX-FileCopyrightText: (c) ") || content.startsWith("<%--\n/**\n * SPDX-FileCopyrightText: (c) ") || content.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!--\n/**\n * SPDX-FileCopyrightText: (c) "))) {
            this.addMessage(fileName, "File must start with copyright");
            return content;
        }
        SourceProcessor sourceProcessor = this.getSourceProcessor();
        SourceFormatterArgs sourceFormatterArgs = sourceProcessor.getSourceFormatterArgs();
        for (String currentBranchRenamedFileName : this._getCurrentBranchRenamedFileNames(sourceFormatterArgs)) {
            if (!absolutePath.endsWith(currentBranchRenamedFileName)) continue;
            return content;
        }
        for (String currentBranchAddedFileNames : this._getCurrentBranchAddedFileName(sourceFormatterArgs)) {
            if (!absolutePath.endsWith(currentBranchAddedFileNames)) continue;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
            String currentYear = simpleDateFormat.format(new Date());
            String year = s.substring(0, 4);
            if (year.equals(currentYear)) continue;
            return StringUtil.replaceFirst(content, year, currentYear, x + 35);
        }
        return content;
    }

    private synchronized List<String> _getCurrentBranchAddedFileName(SourceFormatterArgs sourceFormatterArgs) throws Exception {
        if (_currentBranchAddedFileNames != null) {
            return _currentBranchAddedFileNames;
        }
        _currentBranchAddedFileNames = GitUtil.getCurrentBranchAddedFileNames(sourceFormatterArgs.getBaseDirName(), sourceFormatterArgs.getGitWorkingBranchName());
        return _currentBranchAddedFileNames;
    }

    private synchronized List<String> _getCurrentBranchRenamedFileNames(SourceFormatterArgs sourceFormatterArgs) throws Exception {
        if (_currentBranchRenamedFileNames != null) {
            return _currentBranchRenamedFileNames;
        }
        _currentBranchRenamedFileNames = GitUtil.getCurrentBranchRenamedFileNames(sourceFormatterArgs.getBaseDirName(), sourceFormatterArgs.getGitWorkingBranchName());
        return _currentBranchRenamedFileNames;
    }
}

