/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseUpgradeMatcherReplacementCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaAddFolderParameterCheck
extends BaseUpgradeMatcherReplacementCheck {
    @Override
    protected String formatMatcherIteration(String content, String newContent, Matcher matcher) {
        String methodCall = JavaSourceUtil.getMethodCall(content, matcher.start());
        List<String> parameterList = JavaSourceUtil.getParameterList(methodCall);
        if (parameterList.size() >= 7) {
            return newContent;
        }
        String variable = matcher.group(1);
        if (variable.equals("JournalFolderLocalServiceUtil")) {
            return this._addParameter(newContent, methodCall);
        }
        String variableTypeName = this.getVariableTypeName(newContent, newContent, variable);
        if (variableTypeName.equals("JournalFolderService") || variableTypeName.equals("JournalFolderLocalService")) {
            newContent = this._addParameter(newContent, methodCall);
        }
        return newContent;
    }

    @Override
    protected Pattern getPattern() {
        return Pattern.compile("(\\w+)\\.addFolder\\(");
    }

    private String _addParameter(String content, String methodCall) {
        return StringUtil.replace(content, methodCall, StringUtil.replace(methodCall, ".addFolder(", ".addFolder(null, "));
    }
}

