/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.util;

import com.liferay.poshi.core.util.GetterUtil;
import com.liferay.poshi.core.util.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtil {
    private static final String _REGEX_META = "[\\\\\\^\\$\\{\\}\\[\\]\\(\\)\\.\\*\\+\\?\\|\\<\\>\\-\\&\\%]";
    private static final String _REGEX_TEXT = "(\\(\\?i\\))?(\\.\\*|\\^\\(\\(\\?\\!)?(.*?)(\\.\\*|\\)\\.\\)\\*\\$)?$";

    public static String escapeRegexChars(String regex) {
        String value = RegexUtil.getGroup(regex, _REGEX_TEXT, 3);
        String escapedValue = StringUtil.regexReplaceAll(value, _REGEX_META, "\\\\$0");
        return StringUtil.replace(regex, value, escapedValue);
    }

    public static String getGroup(String content, String regex, int group) {
        Pattern pattern = Pattern.compile(regex, 32);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(group);
        }
        return "";
    }

    public static String replace(String content, String regex, String group) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(GetterUtil.getInteger(group));
        }
        return null;
    }
}

