/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class UpgradeJavaCheck
extends BaseFileCheck {
    private Map<String, String> _importsMap;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!fileName.endsWith(".java")) {
            return content;
        }
        JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
        return this._fixImports(javaClass, content);
    }

    private String _fixImports(JavaClass javaClass, String content) throws Exception {
        Map<String, String> importsMap = this._getImportsMap();
        ArrayList<String> variables = new ArrayList<String>();
        ArrayList<String> newVariables = new ArrayList<String>();
        for (String importName : javaClass.getImportNames()) {
            String newClassName;
            String newImportName = importsMap.get(importName);
            if (newImportName == null) continue;
            content = StringUtil.replace(content, StringBundler.concat("import ", importName, ";"), StringBundler.concat("import ", newImportName, ";"));
            String className = SourceFormatterUtil.getSimpleName(importName);
            if (className.equals(newClassName = SourceFormatterUtil.getSimpleName(newImportName))) continue;
            variables.add(className);
            variables.add(StringUtil.lowerCaseFirstLetter(className));
            newVariables.add(newClassName);
            newVariables.add(StringUtil.lowerCaseFirstLetter(newClassName));
        }
        if (!newVariables.isEmpty()) {
            content = StringUtil.replace(content, ArrayUtil.toStringArray(variables), ArrayUtil.toStringArray(newVariables));
        }
        return content;
    }

    private synchronized Map<String, String> _getImportsMap() throws Exception {
        if (this._importsMap == null) {
            this._importsMap = this._getMap("imports.txt");
        }
        return this._importsMap;
    }

    private Map<String, String> _getMap(String fileName) throws Exception {
        String[] lines;
        HashMap<String, String> map = new HashMap<String, String>();
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("dependencies/" + fileName);
        if (inputStream == null) {
            return map;
        }
        for (String line : lines = StringUtil.splitLines(StringUtil.read(inputStream))) {
            int separatorIndex = line.indexOf("=");
            map.put(line.substring(0, separatorIndex), line.substring(separatorIndex + 1));
        }
        return map;
    }
}

