/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaSearchVocabulariesMethodCheck
extends BaseFileCheck {
    private static final Pattern _searchVocabulariesPattern = Pattern.compile("\\w+\\.searchVocabularies\\(");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!fileName.endsWith(".java")) {
            return content;
        }
        String newContent = content;
        JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            if (!childJavaTerm.isJavaMethod()) continue;
            JavaMethod javaMethod = (JavaMethod)childJavaTerm;
            String javaMethodContent = javaMethod.getContent();
            Matcher matcher = _searchVocabulariesPattern.matcher(javaMethodContent);
            while (matcher.find()) {
                List<String> parameterList;
                String methodCall = JavaSourceUtil.getMethodCall(javaMethodContent, matcher.start());
                if (!this.hasClassOrVariableName("AssetVocabularyService", content, content, methodCall) && !this.hasClassOrVariableName("AssetVocabularyLocalService", content, content, methodCall) || (parameterList = JavaSourceUtil.getParameterList(methodCall)).size() != 5) continue;
                String[] parameterTypes = new String[]{"long", "long", "String", "int", "int"};
                if (!this.hasParameterTypes(javaMethodContent, javaMethodContent, ArrayUtil.toStringArray(parameterList), parameterTypes)) {
                    this.addMessage(fileName, StringBundler.concat("Unable to format searchVocabularies method from ", "AssetVocabularyService and AssetVocabulary", "LocalService. Fill the new parameters manually, ", "see LPS-189866"));
                    continue;
                }
                String newMethod = this._addOrReplaceParameters(matcher.group(0), methodCall, parameterList);
                newContent = StringUtil.replace(newContent, methodCall, newMethod);
                newContent = JavaSourceUtil.addImports(newContent, "com.liferay.portal.kernel.search.Sort");
            }
        }
        return newContent;
    }

    private String _addOrReplaceParameters(String group, String methodCall, List<String> parameterList) {
        parameterList.add(3, "new int[]{}");
        parameterList.add(6, "new Sort()");
        parameterList.set(1, StringBundler.concat("new long[]{", parameterList.get(1), "}"));
        StringBundler sb = new StringBundler(3);
        sb.append(group);
        sb.append(StringUtil.merge(parameterList, ", "));
        sb.append(")");
        return StringUtil.replace(methodCall, methodCall, sb.toString());
    }
}

