/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core;

import com.liferay.poshi.core.PoshiContext;
import com.liferay.poshi.core.PoshiGetterUtil;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.core.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.dom4j.Element;

public final class PoshiStackTrace {
    private static final Map<String, PoshiStackTrace> _poshiStackTraces = new HashMap<String, PoshiStackTrace>();
    private Element _currentElement;
    private final Stack<PoshiFilePath> _poshiFilePaths = new Stack();
    private final Stack<StackTraceElement> _stackTraceElements = new Stack();

    public static void clear(String classCommandName) {
        if (_poshiStackTraces.containsKey(classCommandName)) {
            _poshiStackTraces.remove(classCommandName);
        }
    }

    public static synchronized PoshiStackTrace getPoshiStackTrace(String classCommandName) {
        if (!_poshiStackTraces.containsKey(classCommandName)) {
            _poshiStackTraces.put(classCommandName, new PoshiStackTrace());
        }
        return _poshiStackTraces.get(classCommandName);
    }

    public void emptyStackTrace() {
        while (!this._stackTraceElements.isEmpty()) {
            this._stackTraceElements.pop();
        }
    }

    public String getCurrentFilePath() {
        PoshiFilePath poshiFilePath = this._poshiFilePaths.peek();
        return poshiFilePath.getFilePath();
    }

    public String getCurrentNamespace() {
        if (this._poshiFilePaths.isEmpty()) {
            return PoshiContext.getDefaultNamespace();
        }
        String filePath = this.getCurrentFilePath();
        return PoshiContext.getNamespaceFromFilePath(filePath);
    }

    public String getCurrentNamespace(String namespacedClassCommandName) {
        String namespace = PoshiGetterUtil.getNamespaceFromNamespacedClassCommandName(namespacedClassCommandName);
        if (Validator.isNull(namespace)) {
            namespace = this.getCurrentNamespace();
        }
        return namespace;
    }

    public String getNamespaceFromNamespacedClassCommandName(String namespacedClassCommandName) {
        String namespace = PoshiGetterUtil.getNamespaceFromNamespacedClassCommandName(namespacedClassCommandName);
        if (Validator.isNull(namespace)) {
            namespace = this.getCurrentNamespace();
        }
        return namespace;
    }

    public String getSimpleStackTraceMessage() {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement stackTraceElement : this._stackTraceElements) {
            String fileName = stackTraceElement.getFileName();
            if (fileName.contains(".function")) continue;
            sb.append(this._getStackTraceLine(PoshiGetterUtil.getFileNameFromFilePath(fileName), stackTraceElement.getMethodName(), stackTraceElement.getLineNumber()));
        }
        PoshiFilePath poshiFilePath = this._poshiFilePaths.peek();
        String currentFilePath = poshiFilePath.getFilePath();
        if (!currentFilePath.contains(".function")) {
            sb.append(this._getStackTraceLine(PoshiGetterUtil.getFileNameFromFilePath(currentFilePath), poshiFilePath.getCommandName(), PoshiGetterUtil.getLineNumber(this._currentElement)));
        }
        return sb.toString();
    }

    public StackTraceElement[] getStackTrace() {
        ArrayList<StackTraceElement> stackTraceElements = new ArrayList<StackTraceElement>((Stack)this._stackTraceElements.clone());
        PoshiFilePath poshiFilePath = this._poshiFilePaths.peek();
        stackTraceElements.add(new StackTraceElement(poshiFilePath.getClassName(), poshiFilePath.getCommandName(), poshiFilePath.getFilePath(), PoshiGetterUtil.getLineNumber(this._currentElement)));
        Collections.reverse(stackTraceElements);
        return stackTraceElements.toArray(new StackTraceElement[0]);
    }

    public String getStackTraceMessage(String msg) {
        StringBuilder sb = new StringBuilder();
        if (Validator.isNotNull(msg)) {
            sb.append(msg);
        }
        PoshiFilePath poshiFilePath = this._poshiFilePaths.peek();
        sb.append("\n");
        sb.append(this._getStackTraceLine(poshiFilePath.getFilePath(), poshiFilePath.getCommandName(), PoshiGetterUtil.getLineNumber(this._currentElement)));
        Stack stackTraceElements = (Stack)this._stackTraceElements.clone();
        while (!stackTraceElements.isEmpty()) {
            sb.append("\n");
            StackTraceElement stackTraceElement = (StackTraceElement)stackTraceElements.pop();
            sb.append(this._getStackTraceLine(stackTraceElement));
        }
        return sb.toString();
    }

    public void popStackTrace() {
        this._poshiFilePaths.pop();
        this._stackTraceElements.pop();
    }

    public void printStackTrace() {
        this.printStackTrace(null);
    }

    public void printStackTrace(String msg) {
        System.out.println(this.getStackTraceMessage(msg));
    }

    public void pushStackTrace(Element element) throws Exception {
        PoshiFilePath poshiFilePath = this._poshiFilePaths.peek();
        this._stackTraceElements.push(new StackTraceElement(poshiFilePath.getClassName(), poshiFilePath.getCommandName(), poshiFilePath.getFilePath(), PoshiGetterUtil.getLineNumber(element)));
        String namespacedClassCommandName = null;
        String classType = null;
        if (element.attributeValue("function") != null) {
            namespacedClassCommandName = element.attributeValue("function");
            classType = "function";
        } else if (element.attributeValue("macro") != null) {
            namespacedClassCommandName = element.attributeValue("macro");
            classType = "macro";
        } else if (element.attributeValue("test-case") != null) {
            namespacedClassCommandName = element.attributeValue("test-case");
            String className = PoshiGetterUtil.getClassNameFromNamespacedClassCommandName(namespacedClassCommandName);
            if (className.equals("super")) {
                className = PoshiGetterUtil.getExtendedTestCaseName();
                namespacedClassCommandName = namespacedClassCommandName.replaceFirst("super", className);
            }
            classType = "test-case";
        } else {
            this.printStackTrace();
            throw new Exception("Missing (function|macro|test-case) attribute");
        }
        this._pushFilePath(namespacedClassCommandName, classType);
    }

    public void setCurrentElement(Element currentElement) {
        this._currentElement = currentElement;
    }

    public void startStackTrace(String classCommandName, String classType) {
        this._pushFilePath(classCommandName, classType);
    }

    private PoshiStackTrace() {
    }

    private String _getStackTraceLine(StackTraceElement stackTraceElement) {
        return this._getStackTraceLine(stackTraceElement.getFileName(), stackTraceElement.getMethodName(), stackTraceElement.getLineNumber());
    }

    private String _getStackTraceLine(String filePath, String commandName, int lineNumber) {
        return StringUtil.combine(filePath, "[", commandName + "]:", String.valueOf(lineNumber));
    }

    private void _pushFilePath(String namespacedClassCommandName, String classType) {
        String classCommandName = PoshiGetterUtil.getClassCommandNameFromNamespacedClassCommandName(namespacedClassCommandName);
        String className = PoshiGetterUtil.getClassNameFromNamespacedClassCommandName(classCommandName);
        String fileExtension = PoshiGetterUtil.getFileExtensionFromClassType(classType);
        String filePath = PoshiContext.getFilePathFromFileName(className + "." + fileExtension, this.getCurrentNamespace(namespacedClassCommandName));
        if (classType.equals("test-case") && filePath == null) {
            filePath = PoshiContext.getFilePathFromFileName(className + ".prose", this.getCurrentNamespace(namespacedClassCommandName));
        }
        String commandName = PoshiGetterUtil.getCommandNameFromNamespacedClassCommandName(namespacedClassCommandName);
        this._poshiFilePaths.push(new PoshiFilePath(className, commandName, filePath));
    }

    private class PoshiFilePath {
        private final String _className;
        private final String _commandName;
        private final String _filePath;

        public PoshiFilePath(String className, String commandName, String filePath) {
            this._className = className;
            this._commandName = commandName;
            this._filePath = filePath;
        }

        public String getClassName() {
            return this._className;
        }

        public String getCommandName() {
            return this._commandName;
        }

        public String getFilePath() {
            return this._filePath;
        }
    }
}

