/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.GitUtil;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.processor.FTLSourceProcessor;
import com.liferay.source.formatter.processor.JSPSourceProcessor;
import com.liferay.source.formatter.processor.SourceProcessor;
import java.util.List;

public class IllegalTaglibsCheck
extends BaseFileCheck {
    private static final String _FTL_REPLACED_TAGLIBS_KEY = "ftlReplacedTaglibs";
    private static final String _JSP_REPLACED_TAGLIBS_KEY = "jspReplacedTaglibs";

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        SourceProcessor sourceProcessor = this.getSourceProcessor();
        SourceFormatterArgs sourceFormatterArgs = sourceProcessor.getSourceFormatterArgs();
        if (!sourceFormatterArgs.isFormatCurrentBranch()) {
            return content;
        }
        List<String> replacedTaglibs = null;
        if (sourceProcessor instanceof FTLSourceProcessor) {
            replacedTaglibs = this.getAttributeValues(_FTL_REPLACED_TAGLIBS_KEY, absolutePath);
        } else if (sourceProcessor instanceof JSPSourceProcessor) {
            replacedTaglibs = this.getAttributeValues(_JSP_REPLACED_TAGLIBS_KEY, absolutePath);
        }
        if (ListUtil.isEmpty(replacedTaglibs)) {
            return content;
        }
        String currentBranchFileDiff = GitUtil.getCurrentBranchFileDiff(sourceFormatterArgs.getBaseDirName(), sourceFormatterArgs.getGitWorkingBranchName(), absolutePath);
        block0: for (String line : StringUtil.splitLines(currentBranchFileDiff)) {
            if (!line.startsWith("+")) continue;
            for (String replacedTaglib : replacedTaglibs) {
                String[] replacedTaglibArray = StringUtil.split(replacedTaglib, "->");
                if (replacedTaglibArray.length != 2 || !line.endsWith("<" + replacedTaglibArray[0]) && !line.contains("<" + replacedTaglibArray[0] + " ")) continue;
                this.addMessage(fileName, StringBundler.concat("Use <", replacedTaglibArray[1], "> tag instead of <", replacedTaglibArray[0], ">"));
                continue block0;
            }
        }
        return content;
    }
}

