/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.check.BaseUpgradeCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaFetchAssetCategoryByExternalReferenceCodeCheck
extends BaseUpgradeCheck {
    private static final Pattern _fetchAssetCategoryByExternalReferenceCodePattern = Pattern.compile("\\w+\\.fetchAssetCategoryByExternalReferenceCode\\(");

    @Override
    protected String format(String fileName, String absolutePath, String content) throws Exception {
        JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            if (!childJavaTerm.isJavaMethod()) continue;
            JavaMethod javaMethod = (JavaMethod)childJavaTerm;
            String javaMethodContent = javaMethod.getContent();
            Matcher matcher = _fetchAssetCategoryByExternalReferenceCodePattern.matcher(javaMethodContent);
            while (matcher.find()) {
                String variableName;
                String methodCall = JavaSourceUtil.getMethodCall(javaMethodContent, matcher.start());
                List<String> parameterList = JavaSourceUtil.getParameterList(methodCall);
                if (parameterList.size() != 2 || (variableName = this.getVariableName(methodCall)) != null && !variableName.contains("AssetCategoryLocalServiceUtil") && !this.hasClassOrVariableName("AssetCategoryLocalService", content, content, methodCall)) continue;
                String[] parameterTypes = new String[]{"long", "String"};
                String message = StringBundler.concat("The fetchAssetCategoryByExternalReferenceCode method ", "from AssetCategoryLocalService and AssetCategoryLocal", "ServiceUtil no longer uses companyId as a parameter and ", "has changed the order of its parameters. Fill the new ", "parameters manually, see LPS-194134.");
                if (!this.hasValidParameters(parameterTypes.length, fileName, javaMethodContent, message, parameterList, parameterTypes)) continue;
                this.addMessage(fileName, message);
            }
        }
        return content;
    }
}

