/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.exception.UpgradeCatchAllException;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeCatchAllCheck
extends BaseFileCheck {
    private static boolean _testMode;

    public static String[] getExpectedMessages() throws Exception {
        ArrayList<String> expectedMessages = new ArrayList<String>();
        JSONArray jsonArray = UpgradeCatchAllCheck._getReplacementsJSONArray("replacements.json");
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String from = jsonObject.getString("from");
            if (!from.contains("(")) continue;
            expectedMessages.add(UpgradeCatchAllCheck._getMessage(jsonObject));
        }
        return ArrayUtil.toStringArray(expectedMessages);
    }

    public static void setTestMode(boolean testMode) {
        _testMode = testMode;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        JSONArray jsonArray = UpgradeCatchAllCheck._getReplacementsJSONArray("replacements.json");
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (!this._hasValidExtension(fileName, jsonObject)) continue;
            String oldContent = content;
            content = fileName.endsWith(".java") ? this._formatJava(content, fileName, jsonObject) : this._formatGeneral(content, fileName, jsonObject);
            if (!_testMode || !oldContent.equals(content)) continue;
            throw new UpgradeCatchAllException("Unable to process pattern " + jsonObject.getString("from") + " or there is no test associated with it");
        }
        _testMode = false;
        return content;
    }

    private static String _getMessage(JSONObject jsonObject) {
        String from;
        int periodIndex;
        StringBundler sb = new StringBundler(6);
        sb.append("See ");
        sb.append(jsonObject.getString("issueKey"));
        sb.append(", ");
        Object[] classNames = JSONUtil.toStringArray(jsonObject.getJSONArray("classNames"));
        if (classNames.length > 0) {
            sb.append(StringUtil.merge(classNames, "/"));
        }
        if ((periodIndex = (from = jsonObject.getString("from")).indexOf(46)) != -1) {
            from = StringUtil.replace(from, '.', '#');
        } else {
            sb.append("#");
        }
        int parenthesisIndex = from.indexOf(40);
        if (parenthesisIndex != -1) {
            sb.append(from.substring(0, parenthesisIndex));
        } else {
            sb.append(from);
        }
        return sb.toString();
    }

    private static Pattern _getPattern(JSONObject jsonObject) {
        String from = jsonObject.getString("from");
        if (from.contains("(")) {
            from = from.substring(0, from.indexOf(40));
        }
        String regex = "\\w+\\.[\\w\\(\\)\\s\\.]*" + from;
        if (from.contains(".")) {
            regex = StringUtil.replace(from, '.', "\\.\\s*");
        }
        return Pattern.compile(regex + "\\(");
    }

    private static JSONArray _getReplacementsJSONArray(String fileName) throws Exception {
        ClassLoader classLoader = UpgradeCatchAllCheck.class.getClassLoader();
        return new JSONArrayImpl(StringUtil.read(classLoader.getResourceAsStream("dependencies/" + fileName)));
    }

    private String _addNewReference(String content, String newReference) {
        if (!newReference.equals("")) {
            content = JavaSourceUtil.addImports(content, "org.osgi.service.component.annotations.Reference");
            return StringUtil.replaceLast(content, '}', "\n\t@Reference\n\tprivate " + newReference + ";\n\n}");
        }
        return content;
    }

    private String _addOrReplaceParameters(String newMethodCall, List<String> parameterNames, List<String> newParameterNames) {
        StringBundler sb = new StringBundler(2 + newParameterNames.size());
        sb.append(newMethodCall);
        ArrayList<String> interpolatedNewParameterNames = new ArrayList<String>();
        for (String newParameterName : newParameterNames) {
            String prefix;
            if (newParameterName.contains(prefix = "param#")) {
                int index = GetterUtil.getInteger(newParameterName.substring(newParameterName.indexOf(35) + 1, newParameterName.lastIndexOf(35)));
                interpolatedNewParameterNames.add(StringUtil.replace(newParameterName, prefix + index + '#', parameterNames.get(index)));
                continue;
            }
            interpolatedNewParameterNames.add(newParameterName);
        }
        sb.append(StringUtil.merge(interpolatedNewParameterNames, ", "));
        sb.append(")");
        return sb.toString();
    }

    private String _addReplacementDependencies(String fileName, JSONObject jsonObject, String newContent) {
        String[] newImports = JSONUtil.toStringArray(jsonObject.getJSONArray("newImports"));
        if (fileName.endsWith(".java")) {
            newContent = JavaSourceUtil.addImports(newContent, newImports);
            return this._addNewReference(newContent, jsonObject.getString("newReference"));
        }
        if (fileName.endsWith(".jsp")) {
            for (String newImport : newImports) {
                if (newContent.contains(newImport)) continue;
                newContent = StringBundler.concat("<%@ page import=\"", newImport, "\" %>\n\n", newContent);
            }
        }
        return newContent;
    }

    private String _formatGeneral(String content, String fileName, JSONObject jsonObject) {
        String newContent = content;
        Pattern pattern = UpgradeCatchAllCheck._getPattern(jsonObject);
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String methodCall = matcher.group();
            String from = jsonObject.getString("from");
            String to = jsonObject.getString("to");
            if (from.contains("(")) {
                newContent = this._formatParameters(fileName, from, newContent, jsonObject, matcher, newContent, to);
                continue;
            }
            newContent = StringUtil.replace(newContent, methodCall, StringUtil.replace(methodCall, from, to));
        }
        if (!content.equals(newContent)) {
            newContent = this._addReplacementDependencies(fileName, jsonObject, newContent);
        }
        return newContent;
    }

    private String _formatJava(String content, String fileName, JSONObject jsonObject) throws Exception {
        String newContent = content;
        JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            if (!childJavaTerm.isJavaMethod()) continue;
            JavaMethod javaMethod = (JavaMethod)childJavaTerm;
            String javaMethodContent = javaMethod.getContent();
            Pattern pattern = UpgradeCatchAllCheck._getPattern(jsonObject);
            Matcher matcher = pattern.matcher(javaMethodContent);
            while (matcher.find()) {
                String methodCall = matcher.group();
                String[] classNames = JSONUtil.toStringArray(jsonObject.getJSONArray("classNames"));
                if (classNames.length > 0 && !this._hasValidClassName(classNames, content, methodCall)) continue;
                String from = jsonObject.getString("from");
                String to = jsonObject.getString("to");
                if (from.contains("(")) {
                    newContent = this._formatParameters(fileName, from, javaMethodContent, jsonObject, matcher, newContent, to);
                    continue;
                }
                newContent = StringUtil.replaceFirst(newContent, methodCall, StringUtil.replace(methodCall, from, to));
            }
        }
        if (!content.equals(newContent)) {
            newContent = this._addReplacementDependencies(fileName, jsonObject, newContent);
        }
        return newContent;
    }

    private String _formatParameters(String fileName, String from, String javaMethodContent, JSONObject jsonObject, Matcher matcher, String newContent, String to) {
        String methodCall = JavaSourceUtil.getMethodCall(javaMethodContent, matcher.start());
        List<String> parameterNames = JavaSourceUtil.getParameterList(methodCall);
        List<String> parameterTypes = JavaSourceUtil.getParameterList(from);
        if (parameterNames.size() != parameterTypes.size()) {
            return newContent;
        }
        if (fileName.endsWith(".java") && !this.hasParameterTypes(javaMethodContent, javaMethodContent, ArrayUtil.toStringArray(parameterNames), ArrayUtil.toStringArray(parameterTypes))) {
            this.addMessage(fileName, UpgradeCatchAllCheck._getMessage(jsonObject));
            return newContent;
        }
        String newMethodCall = to.substring(0, to.indexOf(40) + 1);
        if (!newMethodCall.contains(".")) {
            newMethodCall = StringBundler.concat(this.getVariableName(methodCall), Character.valueOf('.'), newMethodCall);
        }
        newMethodCall = this._addOrReplaceParameters(newMethodCall, parameterNames, JavaSourceUtil.getParameterList(to));
        return StringUtil.replaceFirst(newContent, methodCall, newMethodCall);
    }

    private boolean _hasValidClassName(String[] classNames, String content, String methodCall) {
        for (String className : classNames) {
            if (className.endsWith("Util") && StringUtil.equals(this.getVariableName(methodCall), className)) {
                return true;
            }
            if (className.endsWith("Util") || !this.hasClassOrVariableName(className, content, content, methodCall)) continue;
            return true;
        }
        return false;
    }

    private boolean _hasValidExtension(String fileName, JSONObject jsonObject) {
        String[] validExtensions = JSONUtil.toStringArray(jsonObject.getJSONArray("validExtensions"));
        if (validExtensions.length == 0) {
            validExtensions = new String[]{"java"};
        }
        for (String validExtension : validExtensions) {
            if (!fileName.endsWith('.' + validExtension)) continue;
            return true;
        }
        return false;
    }
}

