/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseUpgradeCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaCommerceOrderItemServicesCheck
extends BaseUpgradeCheck {
    private static final Pattern _addOrUpdateLayoutPattern = Pattern.compile("\\t*\\w+\\.(?:addCommerceOrderItem|deleteCommerceOrderItems)\\(");

    @Override
    protected String format(String fileName, String absolutePath, String content) throws Exception {
        String newContent = content;
        JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            if (!childJavaTerm.isJavaMethod()) continue;
            JavaMethod javaMethod = (JavaMethod)childJavaTerm;
            String javaMethodContent = javaMethod.getContent();
            Matcher matcher = _addOrUpdateLayoutPattern.matcher(javaMethodContent);
            while (matcher.find()) {
                String[] parameterTypes;
                String methodCall = JavaSourceUtil.getMethodCall(javaMethodContent, matcher.start());
                String variableName = this.getVariableName(methodCall);
                if (!variableName.contains("CommerceOrderItemLocalServiceUtil") && !variableName.contains("CommerceOrderItemServiceUtil") && !this.hasClassOrVariableName("CommerceOrderItemLocalService", newContent, newContent, methodCall) && !this.hasClassOrVariableName("CommerceOrderItemService", newContent, newContent, methodCall)) continue;
                String message = StringBundler.concat("Unable to format methods addCommerceOrderItem and ", "deleteCommerceOrderItems from CommerceOrderItemLocal", "Service, CommerceOrderItemLocalServiceUtil, CommerceOrder", "ItemService, CommerceOrderItemServiceUtil. Fill the new ", "parameters manually, see LPS-196580");
                List<String> parameterList = JavaSourceUtil.getParameterList(methodCall);
                String newMethodCall = methodCall;
                if (methodCall.contains(".addCommerceOrderItem")) {
                    parameterTypes = new String[]{"long", "long", "int", "int", "String", "CommerceContext", "ServiceContext"};
                    if (!this.hasValidParameters(7, fileName, javaMethodContent, message, parameterList, parameterTypes)) continue;
                    ArrayList<String> newParmeterList = new ArrayList<String>(7);
                    if (!variableName.contains("CommerceOrderItemLocalServiceUtil") && !variableName.contains("CommerceOrderItemServiceUtil")) {
                        newParmeterList.add("0");
                    }
                    newParmeterList.add(parameterList.get(0));
                    newParmeterList.add(parameterList.get(1));
                    newParmeterList.add(parameterList.get(4));
                    newParmeterList.add(StringBundler.concat("BigDecimal.valueOf(", parameterList.get(2), ")"));
                    newParmeterList.add(StringBundler.concat("BigDecimal.valueOf(", parameterList.get(3), ")"));
                    newParmeterList.add(parameterList.get(5));
                    newParmeterList.add(parameterList.get(6));
                    newMethodCall = newParmeterList.size() == 7 ? JavaSourceUtil.addMethodNewParameters(JavaSourceUtil.getIndent(methodCall), new int[]{4, 6}, matcher.group(), new String[]{parameterList.get(1), null}, newParmeterList) : JavaSourceUtil.addMethodNewParameters(JavaSourceUtil.getIndent(methodCall), new int[]{5, 7}, matcher.group(), new String[]{parameterList.get(1), null}, newParmeterList);
                } else if (methodCall.contains(".deleteCommerceOrderItems") && (variableName.contains("CommerceOrderItemLocalServiceUtil") || this.hasClassOrVariableName("CommerceOrderItemLocalService", newContent, newContent, methodCall))) {
                    parameterTypes = new String[]{"long"};
                    if (!this.hasValidParameters(1, fileName, javaMethodContent, message, parameterList, parameterTypes)) continue;
                    newMethodCall = JavaSourceUtil.addMethodNewParameters(JavaSourceUtil.getIndent(methodCall), new int[]{0}, matcher.group(), new String[]{"0"}, parameterList);
                }
                newContent = StringUtil.replace(newContent, methodCall, newMethodCall);
            }
        }
        return newContent;
    }
}

