/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.source.formatter.check.BaseUpgradeCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaFDSActionProviderCheck
extends BaseUpgradeCheck {
    private static final Pattern _getDropdownItemsMethodCallPattern = Pattern.compile("\\w+\\.getDropdownItems\\s*\\(\\s*.+,\\s*.+,\\s*.+\\s*\\)");
    private static final Pattern _getDropdownItemsMethodPattern = Pattern.compile("getDropdownItems\\s*\\(\\s*HttpServletRequest\\s+.+,\\s*.+,\\s*.+\\s*\\)");

    @Override
    protected String format(String fileName, String absolutePath, String content) throws Exception {
        JavaClass javaClass = JavaClassParser.parseJavaClass(fileName, content);
        List<String> implementedClassNames = javaClass.getImplementedClassNames();
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            String javaMethodContent;
            if (!childJavaTerm.isJavaMethod()) continue;
            JavaMethod javaMethod = (JavaMethod)childJavaTerm;
            String newJavaMethodContent = javaMethodContent = javaMethod.getContent();
            if (implementedClassNames.contains("FDSActionProvider")) {
                newJavaMethodContent = this._formatMethodDefinition(newJavaMethodContent);
            }
            newJavaMethodContent = this._formatMethodCalls(javaClass.getContent(), newJavaMethodContent);
            content = StringUtil.replace(content, javaMethodContent, newJavaMethodContent);
        }
        return content;
    }

    private String _formatMethodCalls(String content, String javaMethodContent) {
        Matcher matcher = _getDropdownItemsMethodCallPattern.matcher(javaMethodContent);
        while (matcher.find()) {
            String methodCall = JavaSourceUtil.getMethodCall(javaMethodContent, matcher.start());
            List<String> parameterList = JavaSourceUtil.getParameterList(methodCall);
            String variableTypeName = this.getVariableTypeName(javaMethodContent, content, parameterList.get(0));
            if (!variableTypeName.equals("HttpServletRequest") || !this.hasClassOrVariableName("FDSActionProvider", javaMethodContent, content, methodCall)) continue;
            javaMethodContent = StringUtil.replace(javaMethodContent, methodCall, this._reorderParameters(methodCall));
        }
        return javaMethodContent;
    }

    private String _formatMethodDefinition(String javaMethodContent) {
        Matcher matcher = _getDropdownItemsMethodPattern.matcher(javaMethodContent);
        if (!matcher.find()) {
            return javaMethodContent;
        }
        String methodCall = JavaSourceUtil.getMethodCall(javaMethodContent, matcher.start());
        return StringUtil.replace(javaMethodContent, methodCall, this._reorderParameters(methodCall));
    }

    private String _reorderParameters(String methodCall) {
        List<String> parameterList = JavaSourceUtil.getParameterList(methodCall);
        return StringUtil.replace(methodCall, JavaSourceUtil.getParameters(methodCall), StringBundler.concat(parameterList.get(1), ", ", parameterList.get(0), ", ", parameterList.get(2)));
    }
}

