/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check.comparator;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;

public class PropertyValueComparator
extends NaturalOrderStringComparator {
    private static final char[][] _REVERSE_ORDER_CHARACTERS = new char[][]{{':', '.'}, {'-', '/'}};

    @Override
    public int compare(String s1, String s2) {
        int value = super.compare(s1, s2);
        if (s1.startsWith(s2) || s2.startsWith(s1)) {
            return value;
        }
        int x = StringUtil.startsWithWeight(s1, s2);
        char c1 = s1.charAt(x);
        char c2 = s2.charAt(x);
        for (char[] array : _REVERSE_ORDER_CHARACTERS) {
            if (!ArrayUtil.contains(array, c1) || !ArrayUtil.contains(array, c2)) continue;
            return -value;
        }
        if (x <= 0) {
            return value;
        }
        if (s1.charAt(x - 1) == '.') {
            if (Character.isUpperCase(c1) && Character.isLowerCase(c2)) {
                return -1;
            }
            if (Character.isLowerCase(c1) && Character.isUpperCase(c2)) {
                return 1;
            }
        }
        if (s1.charAt(x - 1) == '/') {
            if (c1 == '*') {
                return -1;
            }
            if (c2 == '*') {
                return 1;
            }
            if (s1.indexOf(".", x) == -1 || s2.indexOf(".", x) == -1) {
                return value;
            }
            if (s1.indexOf("/", x) == -1 && s2.indexOf("/", x) != -1) {
                return -1;
            }
            if (s1.indexOf("/", x) != -1 && s2.indexOf("/", x) == -1) {
                return 1;
            }
        }
        return value;
    }
}

