/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ChainingCheck
extends BaseCheck {
    private static final String _APPLY_TO_TYPE_CAST_KEY = "applyToTypeCast";
    private static final String _MSG_AVOID_PARENTHESES_CHAINING = "chaining.avoid.parentheses";
    private static final String _MSG_AVOID_TYPE_CAST_CHAINING = "chaining.avoid.type.cast";
    private static final String _MSG_REQUIRED_CHAINING = "chaining.required";
    private static final String _MSG_UNSORTED_RESPONSE = "response.unsorted";
    private static final String _REQUIRED_CHAINING_CLASS_FILE_NAMES_KEY = "requiredChainingClassFileNames";
    private static final Log _log = LogFactoryUtil.getLog(ChainingCheck.class);
    private Map<String, List<String>> _requiredChainingMethodNamesMap;

    public int[] getDefaultTokens() {
        return new int[]{14, 154, 15, 77};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentDetailAST;
        if (detailAST.getType() == 77) {
            this._checkChainingOnParentheses(detailAST);
        }
        if ((parentDetailAST = detailAST.getParent()) != null) {
            return;
        }
        this._checkChainingOnMethodCalls(detailAST);
    }

    private void _checkChainingOnMethodCalls(DetailAST detailAST) {
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            List<DetailAST> childMethodCallDetailASTList;
            DetailAST dotDetailAST = methodCallDetailAST.findFirstToken(59);
            if (dotDetailAST != null && !(childMethodCallDetailASTList = this.getAllChildTokens(dotDetailAST, false, 27)).isEmpty()) continue;
            BaseCheck.ChainInformation chainInformation = this.getChainInformation(methodCallDetailAST);
            List<String> chainedMethodNames = chainInformation.getMethodNames();
            this._checkRequiredChaining(methodCallDetailAST, chainedMethodNames);
            int chainSize = chainedMethodNames.size();
            if (chainSize <= 3) continue;
            this._checkChainOrder(methodCallDetailAST, chainedMethodNames);
        }
    }

    private void _checkChainingOnParentheses(DetailAST detailAST) {
        if (this._isInsideConstructorThisCall(detailAST) || this.hasParentWithTokenType(detailAST, 42)) {
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 59) {
            return;
        }
        DetailAST previousSiblingDetailAST = detailAST.getPreviousSibling();
        if (previousSiblingDetailAST.getType() != 23) {
            this.log(detailAST, _MSG_AVOID_PARENTHESES_CHAINING, new Object[0]);
        } else if (this.isAttributeValue(_APPLY_TO_TYPE_CAST_KEY)) {
            this.log(detailAST, _MSG_AVOID_TYPE_CAST_CHAINING, new Object[0]);
        }
    }

    private void _checkChainOrder(DetailAST methodCallDetailAST, List<String> chainedMethodNames) {
        if (!(Objects.equals(chainedMethodNames.get(0), "status") && Objects.equals(chainedMethodNames.get(chainedMethodNames.size() - 1), "build") && Objects.equals(this.getClassOrVariableName(methodCallDetailAST), "Response"))) {
            return;
        }
        List<String> middleMethodNames = chainedMethodNames.subList(1, chainedMethodNames.size() - 1);
        String unsortedNames = middleMethodNames.toString();
        Collections.sort(middleMethodNames);
        if (!unsortedNames.equals(middleMethodNames.toString())) {
            this.log(methodCallDetailAST, _MSG_UNSORTED_RESPONSE, new Object[0]);
        }
    }

    private void _checkRequiredChaining(DetailAST methodCallDetailAST, List<String> chainedMethodNames) {
        DetailAST firstChildDetailAST;
        DetailAST parentDetailAST;
        String variableTypeName;
        String classOrVariableName = this.getClassOrVariableName(methodCallDetailAST);
        if (classOrVariableName == null) {
            return;
        }
        String fullyQualifiedClassName = variableTypeName = this.getVariableTypeName(methodCallDetailAST, classOrVariableName, false);
        for (String importName : this.getImportNames(methodCallDetailAST)) {
            if (!importName.endsWith("." + variableTypeName)) continue;
            fullyQualifiedClassName = importName;
            break;
        }
        List<String> requiredChainingMethodNames = null;
        requiredChainingMethodNames = fullyQualifiedClassName.equals("org.json.JSONObject") ? Arrays.asList("put", "putOnce", "putOpt") : this._getRequiredChainingMethodNames(fullyQualifiedClassName);
        if (requiredChainingMethodNames == null) {
            return;
        }
        String methodName = chainedMethodNames.get(chainedMethodNames.size() - 1);
        if (!requiredChainingMethodNames.contains(methodName)) {
            return;
        }
        DetailAST topLevelMethodCallDetailAST = methodCallDetailAST;
        while ((parentDetailAST = topLevelMethodCallDetailAST.getParent()).getType() == 59 && (parentDetailAST = parentDetailAST.getParent()).getType() == 27) {
            topLevelMethodCallDetailAST = parentDetailAST;
        }
        parentDetailAST = topLevelMethodCallDetailAST.getParent();
        if (parentDetailAST.getType() != 28) {
            return;
        }
        DetailAST nextSiblingDetailAST = parentDetailAST.getNextSibling();
        if (nextSiblingDetailAST == null || nextSiblingDetailAST.getType() != 45) {
            return;
        }
        if ((nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) == null || nextSiblingDetailAST.getType() != 28) {
            return;
        }
        DetailAST nextMethodCallDetailAST = nextSiblingDetailAST.getFirstChild();
        if (nextMethodCallDetailAST.getType() != 27) {
            return;
        }
        while ((firstChildDetailAST = nextMethodCallDetailAST.getFirstChild()).getType() == 59 && (firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() == 27) {
            nextMethodCallDetailAST = firstChildDetailAST;
        }
        if (classOrVariableName.equals(this.getClassOrVariableName(nextMethodCallDetailAST)) && !Objects.equals(this.getMethodName(nextMethodCallDetailAST), "remove")) {
            this.log(methodCallDetailAST, _MSG_REQUIRED_CHAINING, new Object[]{classOrVariableName + "." + methodName});
        }
    }

    private JavaClass _getJavaClass(String requiredChainingClassFileName) {
        File file = SourceFormatterUtil.getFile(this.getBaseDirName(), requiredChainingClassFileName, this.getMaxDirLevel());
        try {
            if (file != null) {
                return JavaClassParser.parseJavaClass(requiredChainingClassFileName, FileUtil.read(file));
            }
            String portalBranchName = this.getAttributeValue("git.liferay.portal.branch");
            if (Validator.isNull(portalBranchName)) {
                return null;
            }
            URL url = new URL(StringBundler.concat("https://raw.githubusercontent.com/liferay/liferay-portal/", portalBranchName, "/", requiredChainingClassFileName));
            return JavaClassParser.parseJavaClass(requiredChainingClassFileName, StringUtil.read(url.openStream()));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            return null;
        }
    }

    private List<String> _getRequiredChainingMethodNames(String fullyQualifiedClassName) {
        if (this._requiredChainingMethodNamesMap != null) {
            return this._requiredChainingMethodNamesMap.get(fullyQualifiedClassName);
        }
        this._requiredChainingMethodNamesMap = new HashMap<String, List<String>>();
        List<String> requiredChainingClassFileNames = this.getAttributeValues(_REQUIRED_CHAINING_CLASS_FILE_NAMES_KEY);
        for (String requiredChainingClassFileName : requiredChainingClassFileNames) {
            JavaClass javaClass = this._getJavaClass(requiredChainingClassFileName);
            if (javaClass == null) continue;
            ArrayList<String> requiredChainingMethodNames = new ArrayList<String>();
            for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
                JavaMethod javaMethod;
                if (!(javaTerm instanceof JavaMethod) || !(javaMethod = (JavaMethod)javaTerm).isPublic()) continue;
                JavaSignature javaSignature = javaMethod.getSignature();
                if (!Objects.equals(javaClass.getName(), javaSignature.getReturnType())) continue;
                requiredChainingMethodNames.add(javaMethod.getName());
            }
            this._requiredChainingMethodNamesMap.put(javaClass.getPackageName() + "." + javaClass.getName(), requiredChainingMethodNames);
        }
        return this._requiredChainingMethodNamesMap.get(fullyQualifiedClassName);
    }

    private boolean _isInsideConstructorThisCall(DetailAST detailAST) {
        for (DetailAST parentDetailAST = detailAST.getParent(); parentDetailAST != null; parentDetailAST = parentDetailAST.getParent()) {
            String parentDetailASTText = parentDetailAST.getText();
            if (parentDetailAST.getType() != 43 || !parentDetailASTText.equals("this")) continue;
            return true;
        }
        return false;
    }
}

