/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.db.partition.DBPartition;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.spring.orm.LastSessionRecorderHelperUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.TimeZoneThreadLocal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class CompanyThreadLocal {
    private static final Log _log = LogFactoryUtil.getLog(CompanyThreadLocal.class);
    private static final CentralizedThreadLocal<Long> _companyId;
    private static final CentralizedThreadLocal<Boolean> _initializingPortalInstance;
    private static final ThreadLocal<Boolean> _locked;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static User fetchGuestUser() {
        User guestUser;
        Long companyId;
        block52: {
            companyId = _companyId.get();
            if (companyId == 0L) {
                return null;
            }
            guestUser = null;
            try {
                guestUser = UserLocalServiceUtil.fetchGuestUser(companyId);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block52;
                _log.debug(exception);
            }
        }
        if (guestUser != null) {
            return guestUser;
        }
        try (Connection connection = DataAccess.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("select userId, languageId, timeZoneId from User_ where companyId = ? and type_ = ?");){
            preparedStatement.setLong(1, companyId);
            preparedStatement.setInt(2, 0);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) {
                    User user = null;
                    return user;
                }
                guestUser = UserLocalServiceUtil.createUser(resultSet.getLong("userId"));
                guestUser.setLanguageId(resultSet.getString("languageId"));
                guestUser.setTimeZoneId(resultSet.getString("timeZoneId"));
                return guestUser;
            }
        }
        catch (Exception exception) {
            if (!_log.isDebugEnabled()) return guestUser;
            _log.debug(exception);
        }
        return guestUser;
    }

    public static Long getCompanyId() {
        Long companyId = _companyId.get();
        if (_log.isDebugEnabled()) {
            _log.debug("Get company ID " + companyId);
        }
        return companyId;
    }

    public static boolean isInitializingPortalInstance() {
        return _initializingPortalInstance.get();
    }

    public static boolean isLocked() {
        return _locked.get();
    }

    public static SafeCloseable lock(long companyId) {
        long currentCompanyId = _companyId.get();
        if (companyId == currentCompanyId) {
            if (CompanyThreadLocal.isLocked()) {
                return () -> {};
            }
            _locked.set(true);
            return () -> _locked.set(false);
        }
        if (CompanyThreadLocal.isLocked()) {
            throw new UnsupportedOperationException(StringBundler.concat("Company ID ", companyId, " and company ID ", currentCompanyId, " are different"));
        }
        CompanyThreadLocal._syncLastDBPartitionSessionState();
        SafeCloseable safeCloseable = _companyId.setWithSafeCloseable(companyId);
        _locked.set(true);
        return () -> {
            _locked.set(false);
            CompanyThreadLocal._syncLastDBPartitionSessionState();
            safeCloseable.close();
        };
    }

    public static void setCompanyId(Long companyId) {
        if (CompanyThreadLocal._setCompanyId(companyId)) {
            CTCollectionThreadLocal.removeCTCollectionId();
        }
    }

    public static SafeCloseable setInitializingCompanyIdWithSafeCloseable(long companyId) {
        if (companyId > 0L) {
            return _companyId.setWithSafeCloseable(companyId);
        }
        return _companyId.setWithSafeCloseable(0L);
    }

    public static SafeCloseable setInitializingPortalInstance(boolean initializingPortalInstance) {
        return _initializingPortalInstance.setWithSafeCloseable(initializingPortalInstance);
    }

    public static SafeCloseable setWithSafeCloseable(Long companyId) {
        return CompanyThreadLocal.setWithSafeCloseable(companyId, 0L);
    }

    public static SafeCloseable setWithSafeCloseable(Long companyId, Long ctCollectionId) {
        long currentCompanyId = _companyId.get();
        boolean changed = CompanyThreadLocal._setCompanyId(companyId);
        SafeCloseable ctCollectionSafeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)ctCollectionId);
        return () -> {
            if (changed) {
                CompanyThreadLocal._syncLastDBPartitionSessionState();
            }
            _companyId.set(currentCompanyId);
            CompanyThreadLocal._clearUserThreadLocals();
            ctCollectionSafeCloseable.close();
        };
    }

    private static void _clearUserThreadLocals() {
        LocaleThreadLocal.removeDefaultLocale();
        TimeZoneThreadLocal.removeDefaultTimeZone();
    }

    private static boolean _setCompanyId(Long companyId) {
        if (companyId.equals(_companyId.get())) {
            if (!CompanyThreadLocal.isLocked()) {
                return false;
            }
            if (LocaleThreadLocal.getDefaultLocale() == null || TimeZoneThreadLocal.getDefaultTimeZone() == null) {
                CompanyThreadLocal._clearUserThreadLocals();
            }
            return false;
        }
        if (CompanyThreadLocal.isLocked()) {
            throw new UnsupportedOperationException("CompanyThreadLocal modification is not allowed");
        }
        CompanyThreadLocal._syncLastDBPartitionSessionState();
        if (_log.isDebugEnabled()) {
            _log.debug("setCompanyId " + companyId);
        }
        if (companyId > 0L) {
            _companyId.set(companyId);
            CompanyThreadLocal._clearUserThreadLocals();
        } else {
            _companyId.set(0L);
            CompanyThreadLocal._clearUserThreadLocals();
        }
        return true;
    }

    private static void _syncLastDBPartitionSessionState() {
        if (DBPartition.isPartitionEnabled()) {
            LastSessionRecorderHelperUtil.syncLastSessionState((boolean)false);
        }
    }

    static {
        _initializingPortalInstance = new CentralizedThreadLocal<Boolean>(CompanyThreadLocal.class + "._initializingPortalInstance", () -> Boolean.FALSE);
        _locked = new CentralizedThreadLocal<Boolean>(CompanyThreadLocal.class + "._locked", () -> Boolean.FALSE);
        _companyId = new CentralizedThreadLocal<Long>(CompanyThreadLocal.class + "._companyId", () -> 0L);
    }
}

