/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;

public class JSONStylingCheck
extends BaseFileCheck {
    private static final Log _log = LogFactoryUtil.getLog(JSONStylingCheck.class);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws JSONException {
        if (Validator.isNull(content)) {
            return "";
        }
        try {
            content = StringUtil.startsWith(StringUtil.trim(content), "[") ? JSONUtil.toString(new JSONArrayImpl(content)) : (content.endsWith("\n") && fileName.endsWith("/package.json") ? JSONUtil.toString(new JSONObjectImpl(content)) + "\n" : JSONUtil.toString(new JSONObjectImpl(content)));
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug(jsonException);
            }
            return content;
        }
        return this._formatQuotedJSON(content, "#cdata-value");
    }

    private String _fixIndentation(String content, String indent) {
        String[] lines = content.split("\n");
        if (lines.length < 3) {
            return content;
        }
        StringBundler sb = new StringBundler(lines.length * 2);
        for (String line : lines) {
            String trimmedLine = StringUtil.trimLeading(line);
            if (!trimmedLine.equals("[") && !trimmedLine.equals("]")) {
                if (!trimmedLine.startsWith("\"")) {
                    return content;
                }
                if ((trimmedLine = StringUtil.trimLeading(trimmedLine.substring(1))).endsWith("\"")) {
                    trimmedLine = StringUtil.replaceLast(trimmedLine, "\"", "");
                } else if (trimmedLine.endsWith("\",")) {
                    trimmedLine = StringUtil.replaceLast(trimmedLine, "\",", "");
                }
                trimmedLine = trimmedLine.replaceAll("\\\\\"", "\"");
                if (Validator.isNull(trimmedLine)) continue;
            }
            sb.append(trimmedLine);
            sb.append("\n");
        }
        if (sb.index() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        String replacement = "";
        try {
            replacement = JSONUtil.toString(new JSONArrayImpl(sb.toString()));
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug(jsonException);
            }
            return content;
        }
        lines = replacement.split("\n");
        sb = new StringBundler(lines.length * 5 + 3);
        sb.append("[");
        sb.append("\n");
        for (int i = 1; i < lines.length - 1; ++i) {
            String line = lines[i];
            if (line.startsWith("\t")) {
                line = line.substring(1);
            }
            line = StringUtil.replace(line, "\"", "\\\"");
            line = StringUtil.replace(line, '\t', "    ");
            sb.append(indent);
            sb.append("\t");
            sb.append("\"" + line + "\"");
            sb.append(",");
            sb.append("\n");
        }
        sb.setIndex(sb.index() - 2);
        sb.append("\n");
        sb.append(indent);
        sb.append("]");
        return sb.toString();
    }

    private String _formatQuotedJSON(String content, String key) {
        key = StringUtil.quote(key, "\"") + ": [";
        int x = -1;
        while ((x = content.indexOf(key, x + 1)) != -1) {
            int y = x;
            while (true) {
                if ((y = content.indexOf("]", y + 1)) == -1) {
                    continue;
                }
                String line = this.getLine(content, this.getLineNumber(content, y));
                String trimmedLine = line.trim();
                if (trimmedLine.equals("]") || trimmedLine.equals("],")) {
                    String newQuotedJSON;
                    String quotedJSON = content.substring(content.indexOf("[", x), y + 1);
                    if (quotedJSON.equals(newQuotedJSON = this._fixIndentation(quotedJSON, SourceUtil.getIndent(this.getLine(content, this.getLineNumber(content, x)))))) break;
                    return StringUtil.replaceFirst(content, quotedJSON, newQuotedJSON, x);
                }
                ++y;
            }
            ++x;
        }
        return content;
    }
}

