/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.JavaVariable;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaModuleInheritableVariableAccessModifierCheck
extends BaseJavaTermCheck {
    private Map<String, List<String>> _osgiComponentFileNamesMap;

    @Override
    public boolean isModuleSourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws Exception {
        if (javaTerm.getParentJavaClass() != null) {
            return javaTerm.getContent();
        }
        JavaClass javaClass = (JavaClass)javaTerm;
        String packageName = javaClass.getPackageName();
        if (!packageName.startsWith("com.liferay")) {
            return javaTerm.getContent();
        }
        Map<String, List<String>> osgiComponentFileNamesMap = this._getOSGiComponentFileNamesMap();
        Set<String> superClassNames = osgiComponentFileNamesMap.keySet();
        if (!superClassNames.contains(packageName + "." + JavaSourceUtil.getClassName(fileName))) {
            return javaTerm.getContent();
        }
        List<JavaTerm> childJavaTerms = javaClass.getChildJavaTerms();
        for (JavaTerm childJavaTerm : childJavaTerms) {
            if (!childJavaTerm.isJavaVariable()) continue;
            JavaVariable javaVariable = (JavaVariable)childJavaTerm;
            String accessModifier = javaVariable.getAccessModifier();
            String variableContent = javaVariable.getContent();
            if (!accessModifier.equals("private") || !variableContent.contains("@Reference")) continue;
            this.addMessage(fileName, StringBundler.concat("The access modifier of variable '", javaVariable.getName(), "' should be protected as the subclass has ", "'-dsannotations-options: inherit' in bnd.bnd"), javaVariable.getLineNumber());
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private synchronized Map<String, List<String>> _getOSGiComponentFileNamesMap() throws Exception {
        if (this._osgiComponentFileNamesMap != null) {
            return this._osgiComponentFileNamesMap;
        }
        this._osgiComponentFileNamesMap = new HashMap<String, List<String>>();
        String moduleRootDirLocation = "modules/";
        List<Object> fileNames = new ArrayList();
        for (int i = 0; i < this.getMaxDirLevel(); ++i) {
            File file = new File(this.getBaseDirName() + moduleRootDirLocation);
            if (file.exists()) {
                fileNames = SourceFormatterUtil.matchFileContentsForFileNames(Arrays.asList("-E", "@Component\\("), file.getCanonicalPath(), new String[]{"apps/**/*.java", "dxp/apps/**/*.java"});
                break;
            }
            moduleRootDirLocation = "../" + moduleRootDirLocation;
        }
        for (String fileName : fileNames) {
            String bndSettingsContent;
            BNDSettings bndSettings;
            File file;
            if ((fileName = StringUtil.replace(fileName, '\\', '/')).contains("/src/test/java/") || fileName.contains("/test/unit/") || !(file = new File(fileName)).exists() || (bndSettings = this.getBNDSettings(fileName)) == null || !(bndSettingsContent = bndSettings.getContent()).contains("-dsannotations-options: inherit")) continue;
            String className = JavaSourceUtil.getClassName(fileName);
            String superClassName = this._getSuperClassName(FileUtil.read(file), className);
            if (superClassName == null) continue;
            List<String> subclassNames = this._osgiComponentFileNamesMap.get(superClassName);
            if (subclassNames == null) {
                subclassNames = new ArrayList<String>();
            }
            subclassNames.add(className);
            this._osgiComponentFileNamesMap.put(superClassName, subclassNames);
        }
        return this._osgiComponentFileNamesMap;
    }

    private String _getSuperClassName(String content, String className) {
        Pattern pattern = Pattern.compile(className + "\\s+extends\\s+(\\w+)\\W");
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return null;
        }
        String superClassName = matcher.group(1);
        List<String> importNames = JavaSourceUtil.getImportNames(content);
        for (String importName : importNames) {
            if (!importName.endsWith("." + superClassName)) continue;
            return importName;
        }
        return JavaSourceUtil.getPackageName(content) + "." + superClassName;
    }
}

