/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class PoshiDependenciesFileLocationCheck
extends BaseFileCheck {
    private static final String _GLOBAL_DEPENDENCIES_LOCATION = "portal-web/test/functional/com/liferay/portalweb/dependencies";
    private static final String[] _TEST_FILE_LOCATIONS = new String[]{"modules", "portal-web/test/functional/com/liferay/portalweb"};
    private Map<String, Set<String>> _dependenciesFileReferencesMap;
    private Map<String, Set<String>> _dependenciesGlobalFileReferencesMap;
    private List<String> _testCaseFileNames;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!fileName.endsWith(".testcase")) {
            return content;
        }
        this._populateTestCaseAndDependenciesFileNames();
        this._checkDependenciesFileReferences(absolutePath, fileName);
        this._checkGlobalDependenciesFileReferences(absolutePath, fileName);
        return content;
    }

    private void _checkDependenciesFileReferences(String absolutePath, String fileName) {
        block0: for (Map.Entry<String, Set<String>> entry : this._dependenciesFileReferencesMap.entrySet()) {
            Set<String> referencesFileNames = entry.getValue();
            if (referencesFileNames.size() <= 1) continue;
            HashSet<String> removedDuplicatedFilePaths = new HashSet<String>();
            for (String referencesFileName : referencesFileNames) {
                String referencesFilePath = referencesFileName.substring(0, referencesFileName.lastIndexOf("/"));
                removedDuplicatedFilePaths.add(referencesFilePath);
            }
            if (removedDuplicatedFilePaths.size() <= 1) continue;
            for (String referencesFileName : referencesFileNames) {
                if (!referencesFileName.equals(absolutePath)) continue;
                this.addMessage(fileName, StringBundler.concat("Test dependencies file '", entry.getKey(), "' is referenced by multiple modules, move it to ", "global dependencies directory"));
                continue block0;
            }
        }
    }

    private void _checkGlobalDependenciesFileReferences(String absolutePath, String fileName) {
        block0: for (Map.Entry<String, Set<String>> entry : this._dependenciesGlobalFileReferencesMap.entrySet()) {
            Set<String> referencesFileNames = entry.getValue();
            if (referencesFileNames.size() != 1) continue;
            for (String referencesFileName : referencesFileNames) {
                if (!referencesFileName.equals(absolutePath)) continue;
                this.addMessage(fileName, StringBundler.concat("Test dependencies file '", entry.getKey(), "' is only referenced by one module, move it to ", "module dependencies directory"));
                continue block0;
            }
        }
    }

    private boolean _containsFileName(String content, String dependenciesFileName) {
        int x = -1;
        while (true) {
            if ((x = content.indexOf(dependenciesFileName, x + 1)) == -1) {
                return false;
            }
            char c = content.charAt(x - 1);
            if (c != '\"' && c != ',') {
                ++x;
                continue;
            }
            if (x + dependenciesFileName.length() >= content.length()) {
                return false;
            }
            c = content.charAt(x + dependenciesFileName.length());
            if (c == '\"' || c == ',') break;
            ++x;
        }
        return true;
    }

    private synchronized void _populateTestCaseAndDependenciesFileNames() throws IOException {
        if (this._testCaseFileNames != null) {
            return;
        }
        File file = null;
        List<String> fileNames = null;
        File portalDir = this.getPortalDir();
        this._dependenciesFileReferencesMap = new HashMap<String, Set<String>>();
        this._testCaseFileNames = new ArrayList<String>();
        for (String testCaseFileLocation : _TEST_FILE_LOCATIONS) {
            file = new File(portalDir, testCaseFileLocation);
            fileNames = SourceFormatterUtil.scanForFileNames(file.getCanonicalPath(), new String[]{"**/*.testcase"});
            for (String fileName : fileNames) {
                if (!fileName.contains("portal-web") && !fileName.matches(".+/modules/.+-test/src/testFunctional(/.*)?")) continue;
                this._testCaseFileNames.add(fileName);
            }
            fileNames = SourceFormatterUtil.scanForFileNames(file.getCanonicalPath(), new String[]{"**/test/**/dependencies/*", "**/tests/**/dependencies/*"});
            for (String fileName : fileNames) {
                if (fileName.contains("/poshi/") || fileName.contains("/source-formatter/")) continue;
                this._dependenciesFileReferencesMap.put(fileName, new TreeSet());
            }
        }
        this._dependenciesGlobalFileReferencesMap = new HashMap<String, Set<String>>();
        file = new File(portalDir, _GLOBAL_DEPENDENCIES_LOCATION);
        fileNames = SourceFormatterUtil.scanForFileNames(file.getCanonicalPath(), new String[0]);
        for (String fileName : fileNames) {
            if (fileName.contains(".lar/") || fileName.contains(".war/") || fileName.contains(".zip/")) continue;
            this._dependenciesGlobalFileReferencesMap.put(fileName, new TreeSet());
        }
        for (String testCaseFileName : this._testCaseFileNames) {
            Set<String> referencesFileNames;
            String shortFileName;
            int pos;
            String testCaseFileContent = FileUtil.read(new File(testCaseFileName));
            for (Map.Entry<String, Set<String>> entry : this._dependenciesFileReferencesMap.entrySet()) {
                String dependenciesFileName = entry.getKey();
                shortFileName = dependenciesFileName.substring((pos = dependenciesFileName.lastIndexOf("/")) + 1);
                if (!this._containsFileName(testCaseFileContent, shortFileName)) continue;
                referencesFileNames = entry.getValue();
                referencesFileNames.add(testCaseFileName);
                this._dependenciesFileReferencesMap.put(dependenciesFileName, referencesFileNames);
            }
            for (Map.Entry<String, Set<String>> entry : this._dependenciesGlobalFileReferencesMap.entrySet()) {
                String dependenciesGlobalFileName = entry.getKey();
                shortFileName = dependenciesGlobalFileName.substring((pos = dependenciesGlobalFileName.lastIndexOf("/")) + 1);
                if (!this._containsFileName(testCaseFileContent, shortFileName)) continue;
                referencesFileNames = entry.getValue();
                referencesFileNames.add(testCaseFileName);
                this._dependenciesGlobalFileReferencesMap.put(dependenciesGlobalFileName, referencesFileNames);
            }
        }
    }
}

