/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.processor.PropertiesSourceProcessor;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;

public class PropertiesPortalFileCheck
extends BaseFileCheck {
    private static final String _ALLOWED_SINGLE_LINE_PROPERTY_KEYS = "allowedSingleLinePropertyKeys";
    private static final String[] _PORTAL_PROPERTIES_COMMON_PREFIXES = new String[]{"com.liferay.portal.servlet.filters.", "data.limit.model.max.count[com.liferay.", "module.framework."};
    private String _portalPropertiesContent;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        int pos = fileName.lastIndexOf("/");
        String shortFileName = fileName.substring(pos + 1);
        if (!((!this.isPortalSource() && !this.isSubrepository() || !shortFileName.startsWith("portal") || shortFileName.contains("-legacy-") || shortFileName.equals("portal-all.properties") || shortFileName.equals("portal-ext.properties") && absolutePath.contains("/workspaces/") || shortFileName.equals("portal-osgi-configuration.properties") || shortFileName.equals("portal-test.properties") || shortFileName.equals("portal-upgrade-database.properties") || shortFileName.equals("portal-upgrade-ext.properties")) && (this.isPortalSource() || this.isSubrepository() || !shortFileName.equals("portal.properties")))) {
            content = this._sortPortalProperties(absolutePath, content);
            content = this._formatPortalProperties(absolutePath, content);
        }
        return content;
    }

    private String _formatPortalProperties(String absolutePath, String content) throws IOException {
        List<String> allowedSingleLinePropertyKeys = this.getAttributeValues(_ALLOWED_SINGLE_LINE_PROPERTY_KEYS, absolutePath);
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String propertyKey;
                if (line.matches("    [^# ]+?=[^,]+(,[^ ][^,]+)+") && !(propertyKey = StringUtil.extractFirst(StringUtil.trimLeading(line), "=")).contains("regex") && !allowedSingleLinePropertyKeys.contains(propertyKey)) {
                    line = line.replaceFirst("=", "=\\\\\n        ");
                    line = line.replaceAll(",", ",\\\\\n        ");
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    private String _generateProperties(Map<String, List<String>> properties) {
        StringBundler sb = new StringBundler();
        for (Map.Entry<String, List<String>> entry : properties.entrySet()) {
            List<String> values = entry.getValue();
            if (values.size() > 1) {
                sb.append("\n");
            }
            sb.append(entry.getKey());
            sb.append("=");
            if (values.size() > 1) {
                String mergedValues = this._mergeValues(entry.getValue());
                if (!mergedValues.startsWith("[")) {
                    sb.append("\\\n");
                }
                sb.append(mergedValues);
                sb.append("\n");
            } else {
                sb.append(values.get(0));
            }
            sb.append("\n");
        }
        if (sb.length() > 0) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    private synchronized String _getPortalPropertiesContent(String absolutePath) throws IOException {
        if (this._portalPropertiesContent != null) {
            return this._portalPropertiesContent;
        }
        if (this.isPortalSource() || this.isSubrepository()) {
            this._portalPropertiesContent = this.getPortalContent("portal-impl/src/portal.properties", absolutePath);
            if (this._portalPropertiesContent == null) {
                this._portalPropertiesContent = "";
            }
            return this._portalPropertiesContent;
        }
        ClassLoader classLoader = PropertiesSourceProcessor.class.getClassLoader();
        URL url = classLoader.getResource("portal.properties");
        this._portalPropertiesContent = url != null ? IOUtils.toString((URL)url) : "";
        return this._portalPropertiesContent;
    }

    private boolean _hasPortalPropertiesCommonPrefixes(String propertyKey) {
        for (String portalPropertiesCommonPrefix : _PORTAL_PROPERTIES_COMMON_PREFIXES) {
            if (!propertyKey.startsWith(portalPropertiesCommonPrefix)) continue;
            return true;
        }
        return false;
    }

    private String _mergeValues(List<String> values) {
        StringBundler sb = new StringBundler(3 * values.size());
        for (String value : values) {
            if (!StringUtil.equals(value, "]") && !StringUtil.equals(value, "[")) {
                sb.append("    ");
            }
            sb.append(value);
            if (StringUtil.equals(value, "\\")) {
                sb.append("\n");
                continue;
            }
            if (StringUtil.equals(value, "[")) {
                sb.append("\\\n");
                continue;
            }
            sb.append(",\\\n");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    private String _sortPortalProperties(String absolutePath, String content) throws IOException {
        if (absolutePath.endsWith("/portal-impl/src/portal.properties")) {
            return content;
        }
        TreeMap<String, List<String>> propertiesMap = new TreeMap<String, List<String>>(new NaturalOrderStringComparator());
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String key = null;
            String line = null;
            String value = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                List<String> list;
                if (Validator.isNull(line = line.trim()) || line.startsWith("#")) continue;
                int x = line.indexOf(61);
                if (x != -1) {
                    key = line.substring(0, x);
                    if (propertiesMap.containsKey(key)) {
                        String string = content;
                        return string;
                    }
                    value = line.substring(x + 1);
                    if (value == null || value.equals("\\")) continue;
                    list = (List)propertiesMap.get(key);
                    if (list == null) {
                        list = new ArrayList();
                    }
                    if (value.equals("[\\")) {
                        value = StringUtil.removeLast(value, "\\");
                    }
                    list.add(value);
                    propertiesMap.put(key, list);
                    continue;
                }
                value = line;
                if (value.endsWith(",\\")) {
                    value = value.substring(0, value.length() - 2);
                }
                if (key == null) {
                    list = content;
                    return list;
                }
                list = (List)propertiesMap.get(key);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(value);
                propertiesMap.put(key, list);
            }
        }
        String portalPropertiesContent = this._getPortalPropertiesContent(absolutePath);
        TreeMap<String, List<String>> portalOSGiEnvironmentPropertiesMap = new TreeMap<String, List<String>>(new NaturalOrderStringComparator());
        TreeMap<String, List<String>> portalPropertiesMap = new TreeMap<String, List<String>>(new PortalPropertiesComparator());
        Set entrySet = propertiesMap.entrySet();
        Iterator iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry properties = iterator.next();
            String propertyKey = (String)properties.getKey();
            if (!Validator.isChar(propertyKey.charAt(0))) continue;
            if (portalPropertiesContent.contains(propertyKey + "=") || portalPropertiesContent.contains("#" + propertyKey + "=") || this._hasPortalPropertiesCommonPrefixes(propertyKey)) {
                portalPropertiesMap.put(propertyKey, (List<String>)propertiesMap.get(propertyKey));
                iterator.remove();
                continue;
            }
            if (!propertyKey.startsWith("configuration.override.com.liferay.")) continue;
            portalOSGiEnvironmentPropertiesMap.put(propertyKey, (List<String>)propertiesMap.get(propertyKey));
            iterator.remove();
        }
        String newContent = StringBundler.concat(this._generateProperties(portalPropertiesMap), "\n\n", this._generateProperties(propertiesMap), "\n\n", this._generateProperties(portalOSGiEnvironmentPropertiesMap));
        newContent = StringUtil.replace(newContent, "\n\n\n", "\n\n");
        if (!StringUtil.equals(content, newContent = newContent.trim())) {
            return newContent;
        }
        return content;
    }

    private class PortalPropertiesComparator
    extends NaturalOrderStringComparator {
        private final Map<String, Integer> _commonPrefixesLastPositionsMap = new HashMap<String, Integer>();

        public PortalPropertiesComparator() {
            for (String portalPropertiesCommonPrefix : _PORTAL_PROPERTIES_COMMON_PREFIXES) {
                int x = PropertiesPortalFileCheck.this._portalPropertiesContent.lastIndexOf("    " + portalPropertiesCommonPrefix);
                if (x == -1) {
                    x = PropertiesPortalFileCheck.this._portalPropertiesContent.lastIndexOf("    #" + portalPropertiesCommonPrefix);
                }
                this._commonPrefixesLastPositionsMap.put(portalPropertiesCommonPrefix, x);
            }
        }

        @Override
        public int compare(String propertyKey1, String propertyKey2) {
            int propertyKey1Position = this._getPortalPropertiesPosition(PropertiesPortalFileCheck.this._portalPropertiesContent, propertyKey1);
            int propertyKey2Position = this._getPortalPropertiesPosition(PropertiesPortalFileCheck.this._portalPropertiesContent, propertyKey2);
            if (propertyKey1Position != -1 && propertyKey2Position != -1) {
                return propertyKey1Position - propertyKey2Position;
            }
            int propertiesLastPosition1 = this._getCommonPrefixLastPosition(propertyKey1);
            if (propertyKey1Position == -1 && propertyKey2Position != -1) {
                if (propertyKey2Position <= propertiesLastPosition1) {
                    return 1;
                }
                return -1;
            }
            int propertiesLastPosition2 = this._getCommonPrefixLastPosition(propertyKey2);
            if (propertyKey1Position != -1 && propertyKey2Position == -1) {
                if (propertyKey1Position <= propertiesLastPosition2) {
                    return -1;
                }
                return 1;
            }
            if (propertiesLastPosition1 != propertiesLastPosition2) {
                return propertiesLastPosition1 - propertiesLastPosition2;
            }
            return super.compare(propertyKey1, propertyKey2);
        }

        private int _getCommonPrefixLastPosition(String propertyKey) {
            for (Map.Entry<String, Integer> entry : this._commonPrefixesLastPositionsMap.entrySet()) {
                if (!StringUtil.startsWith(propertyKey, entry.getKey())) continue;
                return entry.getValue();
            }
            return -1;
        }

        private int _getPortalPropertiesPosition(String content, String propertyKey) {
            int x = content.indexOf("    " + propertyKey + "=");
            if (x == -1) {
                x = content.indexOf("    #" + propertyKey + "=");
            }
            return x;
        }
    }
}

