/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.GradleSourceUtil;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleRestClientDependenciesCheck
extends BaseFileCheck {
    private static final Pattern _restClientDependencyPattern = Pattern.compile("\\w+ project\\(\".*-rest-client\"\\)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        List<String> dependenciesBlocks = GradleSourceUtil.getDependenciesBlocks(content);
        for (String dependenciesBlock : dependenciesBlocks) {
            int y;
            int x = dependenciesBlock.indexOf("\n");
            if (x == (y = dependenciesBlock.lastIndexOf("\n"))) continue;
            String dependencies = dependenciesBlock.substring(x, y + 1);
            Matcher matcher = _restClientDependencyPattern.matcher(dependencies);
            while (matcher.find()) {
                String matched = matcher.group();
                if (StringUtil.startsWith(matched, "testIntegrationImplementation")) continue;
                this.addMessage(fileName, "Project dependencies '.*-rest-client' can only be used for 'testIntegrationImplementation'", SourceUtil.getLineNumber(content, content.indexOf(matched)));
            }
        }
        return content;
    }
}

