/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.YMLSourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class YMLDefinitionOrderCheck
extends BaseFileCheck {
    private static final Map<String, Integer> _parameterTypesWeightMap = HashMapBuilder.put("cookie", Integer.valueOf(4)).put("header", (Integer)3).put("path", (Integer)1).put("query", (Integer)2).build();
    private static final Pattern _pathPattern1 = Pattern.compile("(?<=\n)( *)\"([^{}\"]*\\{[^}]+\\}[^{}\"]*){2,}\":(\n\\1 .*)*");
    private static final Pattern _pathPattern2 = Pattern.compile("\\{([^{}]+)\\}");
    private static final Pattern _pathPattern3 = Pattern.compile(" *-\n( +)in: path(\n\\1.+)*\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.endsWith(".travis.yml")) {
            return content;
        }
        List<String> directives = YMLSourceUtil.splitDirectives(content);
        StringBundler sb = new StringBundler(directives.size() * 2);
        for (String directive : directives) {
            sb.append(this._sortDefinitions(fileName, directive, ""));
            sb.append("\n---\n");
        }
        sb.setIndex(sb.index() - 1);
        return this._sortPathParameters(sb.toString());
    }

    private List<String> _combineComments(List<String> definitions, String indent) {
        ArrayList<String> definitionsList = new ArrayList<String>();
        StringBundler sb = new StringBundler();
        String previousDefinition = "";
        for (String definition : definitions) {
            if (definition.startsWith(indent + "#")) {
                sb.append(definition);
                sb.append("\n");
            } else if (previousDefinition.startsWith(indent + "#")) {
                sb.append(definition);
                definitionsList.add(sb.toString());
                sb.setIndex(0);
            } else {
                definitionsList.add(definition);
            }
            previousDefinition = definition;
        }
        if (sb.index() > 0) {
            definitionsList.add(StringUtil.trimTrailing(sb.toString()));
        }
        return definitionsList;
    }

    private String _getParameterType(String definition) {
        return definition.replaceAll("(?s).*in: (\\S*).*", "$1");
    }

    private int _getParameterTypeWeight(String definitionKey) {
        if (_parameterTypesWeightMap.containsKey(definitionKey)) {
            return _parameterTypesWeightMap.get(definitionKey);
        }
        return -1;
    }

    private String _removeComments(String definition) {
        int y = definition.indexOf("\n");
        if (y == -1) {
            return definition;
        }
        int x = 0;
        String line = definition.substring(x, y);
        while (line.matches(" *#.*")) {
            x = y + 1;
            if ((y = definition.indexOf("\n", x)) == -1) {
                return definition;
            }
            line = definition.substring(x, y);
        }
        return definition.substring(x);
    }

    private List<String> _removeDuplicateAttribute(List<String> list) {
        ArrayList<String> definitions = new ArrayList<String>();
        for (String s : list) {
            if (definitions.contains(s) && !s.startsWith("{{") && !s.startsWith("#")) continue;
            definitions.add(s);
        }
        return definitions;
    }

    private String _sortDefinitions(String fileName, String content, String indent) {
        List<String> definitions = YMLSourceUtil.getDefinitions(content, indent);
        if (definitions.size() == 1 && !content.contains("\n")) {
            return content;
        }
        definitions = this._removeDuplicateAttribute(definitions);
        definitions = this._combineComments(definitions, indent);
        ArrayList<String> oldDefinitions = new ArrayList<String>(definitions);
        Collections.sort(definitions, new Comparator<String>(){

            @Override
            public int compare(String definition1, String definition2) {
                String trimmedDefinition1 = StringUtil.trimLeading(definition1);
                String trimmedDefinition2 = StringUtil.trimLeading(definition2);
                if (trimmedDefinition1.startsWith("{{") || trimmedDefinition2.startsWith("{{") || Validator.isNull(trimmedDefinition1) || Validator.isNull(trimmedDefinition2)) {
                    return 0;
                }
                String[] definition1Lines = StringUtil.splitLines(YMLDefinitionOrderCheck.this._removeComments(definition1));
                String[] definition2Lines = StringUtil.splitLines(YMLDefinitionOrderCheck.this._removeComments(definition2));
                String trimmedDefinition1Line = definition1Lines[0];
                String trimmedDefinition2Line = definition2Lines[0];
                if (trimmedDefinition1Line.equals("-") || trimmedDefinition2Line.equals("-")) {
                    if (definition1Lines[1].contains("in: ") && definition2Lines[1].contains("in: ")) {
                        return YMLDefinitionOrderCheck.this._sortSpecificDefinitions(definition1, definition2, "name");
                    }
                    return 0;
                }
                if (trimmedDefinition1Line.startsWith("in:") || trimmedDefinition2Line.startsWith("in:")) {
                    if (trimmedDefinition1Line.startsWith("in:")) {
                        return -1;
                    }
                    return 1;
                }
                String definition1Key = definition1.replaceAll("( *#.*(\\Z|\n))*(.*)", "$3");
                String definition2Key = definition2.replaceAll("( *#.*(\\Z|\n))*(.*)", "$3");
                if (Validator.isNull(definition1Key) || Validator.isNull(definition2Key)) {
                    return 0;
                }
                definition1Key = definition1Key.replaceAll("(?s):\n.*", "");
                definition2Key = definition2Key.replaceAll("(?s):\n.*", "");
                return definition1Key.compareTo(definition2Key);
            }
        });
        if (!oldDefinitions.equals(definitions)) {
            StringBundler sb = new StringBundler();
            for (String definition : definitions) {
                sb.append(definition);
                sb.append("\n");
            }
            sb.setIndex(sb.index() - 1);
            String[] lines = content.split("\n");
            content = !indent.equals("") ? lines[0] + "\n" + sb.toString() : sb.toString();
        }
        definitions = YMLSourceUtil.getDefinitions(content, indent);
        for (String definition : definitions) {
            String nestedDefinitionIndent;
            String[] lines = StringUtil.splitLines(definition);
            if (lines.length != 0 && lines[0].matches(" *(description:|.+: +.+)") || (nestedDefinitionIndent = YMLSourceUtil.getNestedDefinitionIndent(definition)).equals("")) continue;
            content = StringUtil.replaceFirst(content, definition, this._sortDefinitions(fileName, definition, nestedDefinitionIndent));
        }
        return content;
    }

    private String _sortPathParameters(String content) {
        Matcher matcher1 = _pathPattern1.matcher(content);
        while (matcher1.find()) {
            String path = matcher1.group();
            String[] lines = path.split("\n", 2);
            Matcher matcher2 = _pathPattern2.matcher(lines[0]);
            LinkedHashMap<String, String> inPathsMap = new LinkedHashMap<String, String>();
            while (matcher2.find()) {
                inPathsMap.put(matcher2.group(1), "");
            }
            int inPathCount = inPathsMap.size();
            Pattern pattern = Pattern.compile("( *-\n( +)in: path(\n\\2.+)*\n){" + inPathCount + "}");
            matcher2 = pattern.matcher(lines[1]);
            while (matcher2.find()) {
                String inPaths = matcher2.group();
                Matcher matcher3 = _pathPattern3.matcher(inPaths);
                while (matcher3.find()) {
                    String inPath = matcher3.group();
                    inPathsMap.replace(inPath.replaceAll("(?s).*name: (\\S+).*", "$1"), inPath);
                }
                StringBundler sb = new StringBundler(inPathCount);
                for (Map.Entry entry : inPathsMap.entrySet()) {
                    sb.append((String)entry.getValue());
                }
                content = StringUtil.replaceFirst(content, inPaths, sb.toString());
            }
        }
        return content;
    }

    private int _sortSpecificDefinitions(String definition1, String definition2, String key) {
        String parameter1Type = this._getParameterType(definition1);
        String parameter2Type = this._getParameterType(definition2);
        Pattern pattern = Pattern.compile("^ *" + key + ": *(\\S*)(\n|\\Z)", 8);
        String value1 = "";
        Matcher matcher = pattern.matcher(definition1);
        if (matcher.find()) {
            value1 = matcher.group(1);
        }
        String value2 = "";
        matcher = pattern.matcher(definition2);
        if (matcher.find()) {
            value2 = matcher.group(1);
        }
        if (parameter1Type.equals(parameter2Type)) {
            return value1.compareTo(value2);
        }
        return this._getParameterTypeWeight(parameter1Type) - this._getParameterTypeWeight(parameter2Type);
    }
}

