/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.util.BNDSourceUtil;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.check.util.SourceUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaParameter;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.ParseException;
import com.liferay.source.formatter.util.FileUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class InstanceInitializerCheck
extends BaseCheck {
    private static final String _MSG_INCORRECT_ASSIGN_ORDER = "assign.order.incorrect";
    private static final String _MSG_INCORRECT_METHOD_CALL_ORDER = "method.call.order.incorrect";
    private static final String _MSG_INLINE_IF_STATEMENT = "if.statement.inline";
    private static final String _MSG_MOVE_ASSIGN_BEFORE_METHOD_CALL = "assign.move.before.method.call";
    private static final String _MSG_USE_SET_METHOD_INSTEAD = "set.method.use.instead";
    private static final Log _log = LogFactoryUtil.getLog(InstanceInitializerCheck.class);
    private volatile Map<String, String> _bundleSymbolicNamesMap;
    private volatile String _rootDirName;

    public int[] getDefaultTokens() {
        return new int[]{11};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        String absolutePath;
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 6) {
            return;
        }
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 136) {
            return;
        }
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 7) {
            return;
        }
        List<DetailAST> exprDetailASTList = this.getAllChildTokens(firstChildDetailAST, false, 28);
        if (exprDetailASTList.size() >= 2) {
            this._checkAttributeOrder(exprDetailASTList);
        }
        if ((absolutePath = this.getAbsolutePath()).contains("/test/") || absolutePath.contains("/testIntegration/")) {
            return;
        }
        JavaClass javaClass = null;
        try {
            javaClass = this._getJavaClass(absolutePath, detailAST, parentDetailAST);
        }
        catch (ParseException | IOException exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            return;
        }
        if (javaClass == null) {
            return;
        }
        List<DetailAST> childDetailASTList = this.getAllChildTokens(firstChildDetailAST, false, 28, 83);
        for (DetailAST childDetailAST : childDetailASTList) {
            if (childDetailAST.getType() == 83) {
                DetailAST slistDetailAST = childDetailAST.findFirstToken(7);
                for (DetailAST exprDetailAST : this.getAllChildTokens(slistDetailAST, false, 28)) {
                    this._checkExprStatement(exprDetailAST, javaClass, true);
                }
                continue;
            }
            this._checkExprStatement(childDetailAST, javaClass, false);
        }
    }

    private void _checkAttributeOrder(List<DetailAST> exprDetailASTList) {
        String previousVariableName = null;
        String previousMethodName = null;
        for (DetailAST exprDetailAST : exprDetailASTList) {
            String methodName;
            DetailAST firstChildDetailAST = exprDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() == 80) {
                String variableName = this.getName(firstChildDetailAST);
                if (Validator.isNotNull(this.getTypeName(this.getVariableTypeDetailAST(firstChildDetailAST, variableName, false), false))) continue;
                if (previousVariableName != null && previousVariableName.compareToIgnoreCase(variableName) > 0) {
                    this.log(exprDetailAST, _MSG_INCORRECT_ASSIGN_ORDER, new Object[]{variableName, previousVariableName, firstChildDetailAST.getLineNo()});
                } else if (Validator.isNotNull(previousMethodName)) {
                    this.log(exprDetailAST, _MSG_MOVE_ASSIGN_BEFORE_METHOD_CALL, new Object[]{variableName, previousMethodName, firstChildDetailAST.getLineNo()});
                }
                previousVariableName = variableName;
                continue;
            }
            if (firstChildDetailAST.getType() != 27 || Validator.isNull(methodName = this.getName(firstChildDetailAST)) || !methodName.matches("set[A-Z].+")) continue;
            if (previousMethodName != null && previousMethodName.compareToIgnoreCase(methodName) > 0) {
                this.log(exprDetailAST, _MSG_INCORRECT_METHOD_CALL_ORDER, new Object[]{methodName, previousMethodName, firstChildDetailAST.getLineNo()});
            }
            previousMethodName = methodName;
        }
    }

    private void _checkExprStatement(DetailAST exprDetailAST, JavaClass javaClass, boolean insideIfStatement) {
        DetailAST firstChildDetailAST = exprDetailAST.getFirstChild();
        if (firstChildDetailAST == null) {
            return;
        }
        if (firstChildDetailAST.getType() == 80) {
            if ((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() != 58) {
                return;
            }
            String variableName = firstChildDetailAST.getText();
            String methodName = "set" + StringUtil.upperCaseFirstLetter(variableName);
            this._checkHasReplacableMethodSignature(firstChildDetailAST, methodName, javaClass, insideIfStatement);
        } else if (firstChildDetailAST.getType() == 27) {
            DetailAST elistDetailAST;
            DetailAST childDetailAST;
            DetailAST dotDetailAST = firstChildDetailAST.findFirstToken(59);
            if (dotDetailAST != null) {
                return;
            }
            String methodName = this.getMethodName(firstChildDetailAST);
            if (!methodName.startsWith("set")) {
                return;
            }
            if (!(insideIfStatement || (childDetailAST = (elistDetailAST = firstChildDetailAST.findFirstToken(34)).getFirstChild()) != null && childDetailAST.getType() != 181 && childDetailAST.findFirstToken(180) == null)) {
                return;
            }
            this._checkHasReplacableMethodSignature(firstChildDetailAST, methodName, javaClass, insideIfStatement);
        }
    }

    private void _checkHasReplacableMethodSignature(DetailAST detailAST, String methodName, JavaClass javaClass, boolean insideIfStatement) {
        for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
            JavaParameter javaParameter;
            String parameterType;
            JavaSignature javaSignature;
            List<JavaParameter> javaParameters;
            JavaMethod javaMethod;
            if (!javaTerm.isJavaMethod() || javaTerm.isPrivate() || !StringUtil.equals(methodName, (javaMethod = (JavaMethod)javaTerm).getName()) || (javaParameters = (javaSignature = javaMethod.getSignature()).getParameters()).size() != 1 || !(parameterType = (javaParameter = javaParameters.get(0)).getParameterType()).startsWith("UnsafeSupplier")) continue;
            if (insideIfStatement) {
                this.log(detailAST, _MSG_INLINE_IF_STATEMENT, new Object[]{methodName, parameterType});
            } else {
                this.log(detailAST, _MSG_USE_SET_METHOD_INSTEAD, new Object[]{methodName, parameterType});
            }
            return;
        }
    }

    private synchronized Map<String, String> _getBundleSymbolicNamesMap(String absolutePath) {
        if (this._bundleSymbolicNamesMap == null) {
            this._bundleSymbolicNamesMap = BNDSourceUtil.getBundleSymbolicNamesMap(this._getRootDirName(absolutePath));
        }
        return this._bundleSymbolicNamesMap;
    }

    private JavaClass _getJavaClass(String absolutePath, DetailAST detailAST, DetailAST parentDetailAST) throws IOException, ParseException {
        String fullyQualifiedTypeName = null;
        DetailAST firstChildDetailAST = parentDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() == 58) {
            fullyQualifiedTypeName = this.getFullyQualifiedTypeName(firstChildDetailAST.getText(), detailAST, false);
        } else if (firstChildDetailAST.getType() == 59) {
            FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
            fullyQualifiedTypeName = fullIdent.getText();
        }
        if (fullyQualifiedTypeName == null) {
            return null;
        }
        File javaFile = JavaSourceUtil.getJavaFile(fullyQualifiedTypeName, this._getRootDirName(absolutePath), this._getBundleSymbolicNamesMap(absolutePath));
        if (javaFile == null) {
            return null;
        }
        return JavaClassParser.parseJavaClass(SourceUtil.getAbsolutePath(javaFile), FileUtil.read(javaFile));
    }

    private synchronized String _getRootDirName(String absolutePath) {
        if (this._rootDirName != null) {
            return this._rootDirName;
        }
        this._rootDirName = SourceUtil.getRootDirName(absolutePath);
        return this._rootDirName;
    }
}

