/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.List;

public class MissingEmptyLineCheck
extends BaseCheck {
    private static final String _ENFORCE_EMPTY_LINE_AFTER_METHOD_NAMES = "enforceEmptyLineAfterMethodNames";
    private static final String _ENFORCE_EMPTY_LINE_BEFORE_METHOD_NAMES = "enforceEmptyLineBeforeMethodNames";
    private static final String _MSG_MISSING_EMPTY_LINE_AFTER_METHOD_NAME = "empty.line.missing.after.method.name";
    private static final String _MSG_MISSING_EMPTY_LINE_AFTER_VARIABLE_DEFINITION = "empty.line.missing.after.variable.definition";
    private static final String _MSG_MISSING_EMPTY_LINE_AFTER_VARIABLE_REFERENCE = "empty.line.missing.after.variable.reference";
    private static final String _MSG_MISSING_EMPTY_LINE_BEFORE_METHOD_NAME = "empty.line.missing.before.method.name";
    private static final String _MSG_MISSING_EMPTY_LINE_BEFORE_VARIABLE_ASSIGN = "empty.line.missing.before.variable.assign";
    private static final String _MSG_MISSING_EMPTY_LINE_BEFORE_VARIABLE_USE = "empty.line.missing.before.variable.use";
    private static final String _MSG_MISSING_EMPTY_LINE_LINE_NUMBER = "empty.line.missing.line.number";

    public int[] getDefaultTokens() {
        return new int[]{80, 11, 27, 10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (detailAST.getType() == 11) {
            this._checkMissingEmptyLineInInstanceInit(detailAST);
            return;
        }
        if (detailAST.getType() == 27) {
            this._checkMissingEmptyLinesAroundMethodCall(detailAST);
            return;
        }
        if (detailAST.getType() == 10) {
            DetailAST parentDetailAST = detailAST.getParent();
            if (parentDetailAST.getType() == 7) {
                this._checkMissingEmptyLineAfterVariableDef(detailAST, "ThemeDisplay");
                this._checkMissingEmptyLineBeforeVariableDef(detailAST);
            }
            return;
        }
        this._checkMissingEmptyLineBeforeAssign(detailAST);
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST == null || firstChildDetailAST.getType() == 59) {
            return;
        }
        String variableName = this._getVariableName(detailAST);
        if (variableName == null) {
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        this._checkMissingEmptyLineAfterReferencingVariable(parentDetailAST, variableName, detailAST, this.getEndLineNumber(detailAST));
        this._checkMissingEmptyLineBetweenAssigningAndUsingVariable(parentDetailAST, variableName, this.getEndLineNumber(detailAST));
    }

    private void _checkMissingEmptyLineAfterMethodCall(DetailAST detailAST, String variableName, DetailAST nextSiblingDetailAST) {
        int nextExpressionStartLineNumber;
        if (nextSiblingDetailAST == null) {
            return;
        }
        int endLineNumber = this.getEndLineNumber(detailAST);
        if (endLineNumber + 1 != (nextExpressionStartLineNumber = this.getStartLineNumber(nextSiblingDetailAST))) {
            return;
        }
        if (nextSiblingDetailAST.getType() == 28) {
            DetailAST firstChildDetailAST;
            List<String> enforceEmptyLineAfterMethodNames = this.getAttributeValues(_ENFORCE_EMPTY_LINE_AFTER_METHOD_NAMES);
            String methodName = this.getMethodName(detailAST);
            if (enforceEmptyLineAfterMethodNames.contains(StringBundler.concat(this.getVariableTypeName(detailAST, variableName, false), ".", methodName))) {
                this.log(endLineNumber, _MSG_MISSING_EMPTY_LINE_AFTER_METHOD_NAME, new Object[]{StringBundler.concat(variableName, ".", methodName)});
            }
            if ((firstChildDetailAST = nextSiblingDetailAST.getFirstChild()).getType() == 27 && variableName.equals(this.getVariableName(firstChildDetailAST))) {
                return;
            }
        }
        if (this.containsVariableName(nextSiblingDetailAST, variableName, null)) {
            this.log(endLineNumber, _MSG_MISSING_EMPTY_LINE_LINE_NUMBER, new Object[]{"after", endLineNumber});
        }
    }

    private void _checkMissingEmptyLineAfterReferencingVariable(DetailAST detailAST, String variableName, DetailAST assignDetailAST, int endLineNumber) {
        String lastAssignedVariableName = null;
        DetailAST previousDetailAST = null;
        boolean referenced = false;
        DetailAST nextSiblingDetailAST = detailAST.getNextSibling();
        while (nextSiblingDetailAST != null && nextSiblingDetailAST.getType() == 45) {
            if ((nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) == null || this.hasPrecedingPlaceholder(nextSiblingDetailAST) || nextSiblingDetailAST.getType() != 28 && nextSiblingDetailAST.getType() != 10) {
                return;
            }
            if (!this.containsVariableName(nextSiblingDetailAST, variableName, assignDetailAST)) {
                if (!referenced) {
                    return;
                }
                int nextExpressionStartLineNumber = this.getStartLineNumber(nextSiblingDetailAST);
                if (endLineNumber + 1 != nextExpressionStartLineNumber) {
                    return;
                }
                if (!this.containsVariableName(previousDetailAST, lastAssignedVariableName, assignDetailAST) || !this.containsVariableName(nextSiblingDetailAST, lastAssignedVariableName, assignDetailAST)) {
                    this.log(nextExpressionStartLineNumber, _MSG_MISSING_EMPTY_LINE_AFTER_VARIABLE_REFERENCE, new Object[]{nextExpressionStartLineNumber, variableName});
                }
                return;
            }
            List<DetailAST> assignDetailASTList = this.getAllChildTokens(nextSiblingDetailAST, false, 80);
            if (assignDetailASTList.size() == 1) {
                lastAssignedVariableName = this._getVariableName(assignDetailASTList.get(0));
            }
            referenced = true;
            endLineNumber = this.getEndLineNumber(nextSiblingDetailAST);
            previousDetailAST = nextSiblingDetailAST;
            nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling();
        }
        return;
    }

    private void _checkMissingEmptyLineAfterVariableDef(DetailAST detailAST, String variableTypeName) {
        DetailAST firstChildDetailAST;
        if (detailAST.findFirstToken(80) == null) {
            return;
        }
        int endLineNumber = this.getEndLineNumber(detailAST);
        String nextLine = this.getLine(endLineNumber);
        if (Validator.isNull(nextLine)) {
            return;
        }
        DetailAST nextSiblingDetailAST = detailAST.getNextSibling();
        if (nextSiblingDetailAST == null || nextSiblingDetailAST.getType() != 45) {
            return;
        }
        if ((nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) == null || this.getHiddenBefore(nextSiblingDetailAST) != null || nextSiblingDetailAST.getType() == 73) {
            return;
        }
        if (variableTypeName.equals(this.getVariableTypeName(detailAST, this.getName(detailAST), false))) {
            this.log(detailAST, _MSG_MISSING_EMPTY_LINE_AFTER_VARIABLE_DEFINITION, new Object[]{variableTypeName});
            return;
        }
        if (nextSiblingDetailAST.getType() == 10) {
            return;
        }
        if (nextSiblingDetailAST.getType() == 28 && (firstChildDetailAST = nextSiblingDetailAST.getFirstChild()).getType() == 80) {
            return;
        }
        this.log(endLineNumber, _MSG_MISSING_EMPTY_LINE_LINE_NUMBER, new Object[]{"after", endLineNumber});
    }

    private void _checkMissingEmptyLineBeforeAssign(DetailAST assignDetailAST) {
        DetailAST parentDetailAST = assignDetailAST.getParent();
        DetailAST nextSiblingDetailAST = parentDetailAST.getNextSibling();
        if (nextSiblingDetailAST == null || nextSiblingDetailAST.getType() != 45 || this._hasPrecedingVariableDef(parentDetailAST)) {
            return;
        }
        List<DetailAST> adjacentAssignDetailASTList = this._getAdjacentAssignDetailASTList(assignDetailAST);
        if (adjacentAssignDetailASTList.size() <= 1) {
            return;
        }
        DetailAST lastAssignDetailAST = adjacentAssignDetailASTList.get(adjacentAssignDetailASTList.size() - 1);
        List<DetailAST> identDetailASTList = this._getFollowingStatementsIdentDetailASTList(lastAssignDetailAST.getParent());
        if (this._containsVariableName(identDetailASTList, assignDetailAST)) {
            return;
        }
        DetailAST firstReferencedAssignDetailAST = null;
        for (int i = 1; i < adjacentAssignDetailASTList.size(); ++i) {
            DetailAST curAssignDetailAST = adjacentAssignDetailASTList.get(i);
            if (this._containsVariableName(identDetailASTList, curAssignDetailAST)) {
                if (firstReferencedAssignDetailAST != null) continue;
                firstReferencedAssignDetailAST = curAssignDetailAST;
                continue;
            }
            if (firstReferencedAssignDetailAST == null) continue;
            return;
        }
        if (firstReferencedAssignDetailAST != null) {
            String name = this.getName(firstReferencedAssignDetailAST);
            if (name == null) {
                name = this.getName(firstReferencedAssignDetailAST.getParent());
            }
            this.log(firstReferencedAssignDetailAST, _MSG_MISSING_EMPTY_LINE_BEFORE_VARIABLE_ASSIGN, new Object[]{name});
        }
    }

    private void _checkMissingEmptyLineBeforeMethodCall(DetailAST detailAST, String variableName, DetailAST previousSiblingDetailAST) {
        DetailAST firstChildDetailAST;
        if (previousSiblingDetailAST == null) {
            return;
        }
        int startLineNumber = this.getStartLineNumber(detailAST);
        int previousExpressionEndLineNumber = this.getEndLineNumber(previousSiblingDetailAST);
        if (previousExpressionEndLineNumber + 1 != startLineNumber) {
            return;
        }
        if (previousSiblingDetailAST.getType() == 28 && (firstChildDetailAST = previousSiblingDetailAST.getFirstChild()).getType() == 27 && variableName.equals(this.getVariableName(firstChildDetailAST))) {
            String methodName;
            List<String> enforceEmptyLineBeforeMethodNames = this.getAttributeValues(_ENFORCE_EMPTY_LINE_BEFORE_METHOD_NAMES);
            if (enforceEmptyLineBeforeMethodNames.contains(methodName = this.getMethodName(detailAST)) && Validator.isNull(this.getParameterDetailAST(detailAST))) {
                this.log(startLineNumber, _MSG_MISSING_EMPTY_LINE_BEFORE_METHOD_NAME, new Object[]{StringBundler.concat(variableName, ".", methodName)});
            }
            return;
        }
        if (this.containsVariableName(previousSiblingDetailAST, variableName, null)) {
            this.log(startLineNumber, _MSG_MISSING_EMPTY_LINE_LINE_NUMBER, new Object[]{"before", startLineNumber});
        }
    }

    private void _checkMissingEmptyLineBeforeVariableDef(DetailAST detailAST) {
        DetailAST firstChildDetailAST;
        if (this.getHiddenBefore(detailAST) != null) {
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 7) {
            return;
        }
        int startLineNumber = this.getStartLineNumber(detailAST);
        String previousLine = this.getLine(startLineNumber - 2);
        if (Validator.isNull(previousLine)) {
            return;
        }
        DetailAST previousSiblingDetailAST = detailAST.getPreviousSibling();
        if (previousSiblingDetailAST == null || previousSiblingDetailAST.getType() != 45) {
            return;
        }
        if ((previousSiblingDetailAST = previousSiblingDetailAST.getPreviousSibling()).getType() == 10) {
            return;
        }
        if (previousSiblingDetailAST.getType() == 28 && (firstChildDetailAST = previousSiblingDetailAST.getFirstChild()).getType() == 80) {
            return;
        }
        this.log(startLineNumber, _MSG_MISSING_EMPTY_LINE_LINE_NUMBER, new Object[]{"before", startLineNumber});
    }

    private void _checkMissingEmptyLineBetweenAssigningAndUsingVariable(DetailAST detailAST, String name, int endLineNumber) {
        DetailAST nextSiblingDetailAST = detailAST.getNextSibling();
        if (nextSiblingDetailAST == null || nextSiblingDetailAST.getType() != 45) {
            return;
        }
        if ((nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling()) == null) {
            return;
        }
        int nextExpressionStartLineNumber = this.getStartLineNumber(nextSiblingDetailAST);
        if (endLineNumber + 1 != nextExpressionStartLineNumber) {
            return;
        }
        List<DetailAST> identDetailASTList = this.getAllChildTokens(nextSiblingDetailAST, true, 58);
        boolean nextVariableUsesVariable = false;
        for (DetailAST identDetailAST : identDetailASTList) {
            String identName = identDetailAST.getText();
            if (!identName.equals(name)) continue;
            DetailAST parentDetailAST = identDetailAST.getParent();
            if (parentDetailAST.getType() == 80 && identDetailAST.getPreviousSibling() == null) {
                return;
            }
            nextVariableUsesVariable = true;
        }
        if (nextVariableUsesVariable) {
            this.log(nextExpressionStartLineNumber, _MSG_MISSING_EMPTY_LINE_BEFORE_VARIABLE_USE, new Object[]{name});
        }
    }

    private void _checkMissingEmptyLineInInstanceInit(DetailAST detailAST) {
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST == null || firstChildDetailAST.getType() != 7) {
            return;
        }
        List<DetailAST> exprDetailASTList = this.getAllChildTokens(firstChildDetailAST, false, 28);
        if (exprDetailASTList.size() < 2) {
            return;
        }
        DetailAST previousExprDetailAST = null;
        for (DetailAST exprDetailAST : exprDetailASTList) {
            if (previousExprDetailAST == null) {
                previousExprDetailAST = exprDetailAST;
                continue;
            }
            firstChildDetailAST = exprDetailAST.getFirstChild();
            DetailAST previousExprFirstChildDetailAST = previousExprDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() != 27 || previousExprFirstChildDetailAST.getType() != 80) {
                previousExprDetailAST = exprDetailAST;
                continue;
            }
            int previousExprEndLineNo = this.getEndLineNumber(previousExprDetailAST);
            if (previousExprEndLineNo + 1 == exprDetailAST.getLineNo()) {
                this.log(previousExprFirstChildDetailAST, _MSG_MISSING_EMPTY_LINE_LINE_NUMBER, new Object[]{"after", previousExprEndLineNo});
            }
            previousExprDetailAST = exprDetailAST;
        }
    }

    private void _checkMissingEmptyLinesAroundMethodCall(DetailAST detailAST) {
        String variableName = this.getVariableName(detailAST);
        if (variableName == null || Character.isUpperCase(variableName.charAt(0))) {
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 28) {
            return;
        }
        DetailAST nextSiblingDetailAST = parentDetailAST.getNextSibling();
        if (nextSiblingDetailAST == null || nextSiblingDetailAST.getType() != 45) {
            return;
        }
        this._checkMissingEmptyLineAfterMethodCall(detailAST, variableName, nextSiblingDetailAST.getNextSibling());
        DetailAST previousSiblingDetailAST = parentDetailAST.getPreviousSibling();
        if (previousSiblingDetailAST == null || previousSiblingDetailAST.getType() != 45) {
            return;
        }
        this._checkMissingEmptyLineBeforeMethodCall(detailAST, variableName, previousSiblingDetailAST.getPreviousSibling());
    }

    private boolean _containsVariableName(List<DetailAST> identDetailASTList, DetailAST assignDetailAST) {
        String variableName = this._getVariableName(assignDetailAST);
        if (variableName == null) {
            return false;
        }
        return this.containsVariableName(identDetailASTList, variableName, assignDetailAST);
    }

    private List<DetailAST> _getAdjacentAssignDetailASTList(DetailAST assignDetailAST) {
        ArrayList<DetailAST> assignDetailASTList = new ArrayList<DetailAST>();
        assignDetailASTList.add(assignDetailAST);
        DetailAST followingStatementDetailAST = this._getFollowingStatementDetailAST(assignDetailAST.getParent(), false);
        while (followingStatementDetailAST != null) {
            DetailAST followingAssignDetailAST = followingStatementDetailAST.findFirstToken(80);
            if (followingAssignDetailAST == null) {
                return assignDetailASTList;
            }
            assignDetailASTList.add(followingAssignDetailAST);
            followingStatementDetailAST = this._getFollowingStatementDetailAST(followingStatementDetailAST, false);
        }
        return assignDetailASTList;
    }

    private DetailAST _getFollowingStatementDetailAST(DetailAST detailAST, boolean allowDividingEmptyLine) {
        int nextStartLineNumber;
        int endLineNumber = this.getEndLineNumber(detailAST);
        DetailAST nextSiblingDetailAST = detailAST.getNextSibling();
        while (true) {
            if (nextSiblingDetailAST == null) {
                return null;
            }
            nextStartLineNumber = this.getStartLineNumber(nextSiblingDetailAST);
            if (nextStartLineNumber > endLineNumber) break;
            nextSiblingDetailAST = nextSiblingDetailAST.getNextSibling();
        }
        if (nextStartLineNumber == endLineNumber + 1) {
            return nextSiblingDetailAST;
        }
        if (this.hasPrecedingPlaceholder(nextSiblingDetailAST)) {
            return null;
        }
        if (allowDividingEmptyLine) {
            return nextSiblingDetailAST;
        }
        return null;
    }

    private List<DetailAST> _getFollowingStatementsIdentDetailASTList(DetailAST detailAST) {
        ArrayList<DetailAST> identDetailASTList = new ArrayList<DetailAST>();
        DetailAST followingStatementDetailAST = this._getFollowingStatementDetailAST(detailAST, true);
        while (followingStatementDetailAST != null) {
            identDetailASTList.addAll(this.getAllChildTokens(followingStatementDetailAST, true, 58));
            followingStatementDetailAST = this._getFollowingStatementDetailAST(followingStatementDetailAST, false);
        }
        return identDetailASTList;
    }

    private String _getVariableName(DetailAST assignDetailAST) {
        DetailAST parentDetailAST = assignDetailAST.getParent();
        if (parentDetailAST.getType() == 28) {
            DetailAST firstChildDetailAST = assignDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() == 58) {
                return firstChildDetailAST.getText();
            }
        } else if (parentDetailAST.getType() == 10) {
            DetailAST nameDetailAST = parentDetailAST.findFirstToken(58);
            return nameDetailAST.getText();
        }
        return null;
    }

    private boolean _hasPrecedingVariableDef(DetailAST variableDefinitionDetailAST) {
        DetailAST previousSiblingDetailAST = variableDefinitionDetailAST.getPreviousSibling();
        if (previousSiblingDetailAST == null || previousSiblingDetailAST.getType() != 45) {
            return false;
        }
        if ((previousSiblingDetailAST = previousSiblingDetailAST.getPreviousSibling()).getType() != 10) {
            return false;
        }
        return this.getEndLineNumber(previousSiblingDetailAST) + 1 == this.getStartLineNumber(variableDefinitionDetailAST);
    }
}

