/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.List;

public class JIRAUtil {
    public static void validateJIRAProjectNames(List<String> commitMessages, List<String> projectNames) throws Exception {
        if (projectNames.isEmpty()) {
            return;
        }
        block0: for (String commitMessage : commitMessages) {
            String[] parts = commitMessage.split(":", 2);
            String commitMessageTitle = parts[1];
            if (Character.isWhitespace(commitMessageTitle.charAt(0))) {
                throw new Exception(StringBundler.concat("Found formatting issue in SHA ", parts[0], "\n", "The commit message should not start with whitespace"));
            }
            int x = parts[1].indexOf("\n");
            if (x != -1) {
                commitMessageTitle = commitMessageTitle.substring(0, x);
            }
            if (commitMessageTitle.startsWith("Revert ") || commitMessageTitle.startsWith("artifact:ignore") || commitMessageTitle.startsWith("build.gradle auto SF") || commitMessageTitle.endsWith("/ci-merge.")) continue;
            for (String projectName : projectNames) {
                if (!commitMessageTitle.startsWith(projectName)) continue;
                continue block0;
            }
            throw new Exception(StringBundler.concat("Found formatting issue in SHA ", parts[0], "\n", "The commit message is missing a reference to a required ", "JIRA project: ", StringUtil.merge(projectNames, ", "), ". Please verify that the JIRA project keys are specified", "in source-formatter.properties in the liferay-portal ", "repository."));
        }
    }
}

