/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.elements;

import com.liferay.poshi.core.PoshiGetterUtil;
import com.liferay.poshi.core.PoshiProperties;
import com.liferay.poshi.core.elements.PoshiElement;
import com.liferay.poshi.core.elements.PoshiNode;
import com.liferay.poshi.core.util.StringUtil;
import com.liferay.poshi.core.util.Validator;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class PoshiElementException
extends Exception {
    private static final int _ERROR_SNIPPET_POSTFIX_SIZE = 7;
    private static final int _ERROR_SNIPPET_PREFIX_SIZE = 7;
    private int _errorLineNumber;
    private String _errorSnippet = "";
    private String _filePath = "Unknown file";
    private PoshiNode<?, ?> _poshiNode;
    private Boolean _warning;

    public static List<Exception> getFilteredExceptions(List<Exception> exceptions) {
        ArrayList<Exception> filteredExceptions = new ArrayList<Exception>();
        for (Exception exception : exceptions) {
            if (exception instanceof PoshiElementException) {
                PoshiElementException poshiElementException = (PoshiElementException)exception;
                if (poshiElementException.isWarning()) continue;
                filteredExceptions.add(poshiElementException);
                continue;
            }
            filteredExceptions.add(exception);
        }
        return filteredExceptions;
    }

    public static PoshiElement getRootPoshiElement(PoshiNode<?, ?> poshiNode) {
        if (Validator.isNotNull(poshiNode.getParent())) {
            PoshiElement parentPoshiElement = (PoshiElement)poshiNode.getParent();
            return PoshiElementException.getRootPoshiElement(parentPoshiElement);
        }
        return (PoshiElement)poshiNode;
    }

    public static List<Exception> getWarnings(List<Exception> exceptions) {
        ArrayList<Exception> warnings = new ArrayList<Exception>();
        for (Exception exception : exceptions) {
            PoshiElementException poshiElementException;
            if (!(exception instanceof PoshiElementException) || !(poshiElementException = (PoshiElementException)exception).isWarning()) continue;
            warnings.add(poshiElementException);
        }
        return warnings;
    }

    public static String join(Object ... objects) {
        StringBuilder sb = new StringBuilder();
        for (Object object : objects) {
            sb.append(object.toString());
        }
        return sb.toString();
    }

    public PoshiElementException(PoshiNode<?, ?> poshiNode, Object ... messageParts) {
        this(PoshiElementException.join(messageParts), poshiNode);
    }

    public PoshiElementException(String msg, int errorLineNumber, String filePath, PoshiNode<?, ?> poshiNode) {
        this(msg);
        this.setErrorLineNumber(errorLineNumber);
        this.setFilePath(filePath);
        this.setPoshiNode(poshiNode);
    }

    public PoshiElementException(String msg, int errorLineNumber, String errorSnippet, URL filePathURL) {
        this(msg);
        this.setErrorLineNumber(errorLineNumber);
        this.setErrorSnippet(errorSnippet);
        this.setFilePath(filePathURL.getPath());
    }

    public PoshiElementException(String msg, PoshiNode<?, ?> poshiNode) {
        this(msg, poshiNode.getPoshiScriptLineNumber(), PoshiElementException.getFilePath(poshiNode), poshiNode);
    }

    public int getErrorLineNumber() {
        return this._errorLineNumber;
    }

    public String getErrorSnippet() {
        if (this._errorSnippet == null && !this._errorSnippet.isEmpty()) {
            return this._errorSnippet;
        }
        PoshiElement rootPoshiElement = PoshiElementException.getRootPoshiElement(this.getPoshiNode());
        int errorLineNumber = this.getErrorLineNumber();
        int startingLineNumber = Math.max(errorLineNumber - 7, 1);
        String poshiScript = rootPoshiElement.getPoshiScript();
        String[] lines = poshiScript.split("\n");
        int endingLineNumber = lines.length;
        endingLineNumber = Math.min(errorLineNumber + 7, endingLineNumber);
        StringBuilder sb = new StringBuilder();
        String lineNumberString = String.valueOf(endingLineNumber);
        int pad = lineNumberString.length() + 2;
        for (int currentLineNumber = startingLineNumber; currentLineNumber <= endingLineNumber; ++currentLineNumber) {
            StringBuilder prefix = new StringBuilder();
            if (currentLineNumber == errorLineNumber) {
                prefix.append(">");
            } else {
                prefix.append(" ");
            }
            prefix.append(" ");
            prefix.append(currentLineNumber);
            sb.append(String.format("%" + pad + "s", prefix.toString()));
            sb.append(" |");
            String line = lines[currentLineNumber - 1];
            sb.append(StringUtil.replace(line, "\t", "    "));
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getFilePath() {
        return this._filePath;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessage());
        sb.append(" at:\n");
        sb.append(this.getFilePath());
        sb.append(":");
        sb.append(this.getErrorLineNumber());
        if (this.getPoshiNode() != null) {
            sb.append("\n");
            sb.append(this.getErrorSnippet());
        }
        return sb.toString();
    }

    public PoshiNode<?, ?> getPoshiNode() {
        return this._poshiNode;
    }

    public String getSimpleMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessage());
        sb.append(" at:\n");
        sb.append(this.getFilePath());
        sb.append(":");
        sb.append(this.getErrorLineNumber());
        return sb.toString();
    }

    public boolean isWarning() {
        if (this._warning == null) {
            this._warning = this._isWarning();
        }
        return this._warning;
    }

    public void setErrorLineNumber(int errorLineNumber) {
        this._errorLineNumber = errorLineNumber;
    }

    public void setErrorSnippet(String errorSnippet) {
        this._errorSnippet = errorSnippet;
    }

    public void setFilePath(String filePath) {
        this._filePath = filePath;
    }

    public void setPoshiNode(PoshiNode<?, ?> poshiNode) {
        this._poshiNode = poshiNode;
    }

    protected static String getFilePath(PoshiNode<?, ?> poshiNode) {
        URL filePathURL = poshiNode.getFilePathURL();
        return filePathURL.getPath();
    }

    private PoshiElementException(String msg) {
        super(msg);
    }

    private boolean _isWarning() {
        String filePath = this.getFilePath();
        if (filePath.contains("com.liferay.poshi.runner.resources")) {
            String fileExtension = PoshiGetterUtil.getFileExtensionFromFilePath(filePath);
            PoshiProperties poshiProperties = PoshiProperties.getPoshiProperties();
            for (String validationResourceFileType : poshiProperties.validationResourceFileTypes) {
                if (!validationResourceFileType.equals(fileExtension)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

