/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.pql;

import com.liferay.poshi.core.pql.PQLModifier;
import com.liferay.poshi.core.pql.PQLModifierFactory;
import java.util.Properties;
import java.util.Set;

public abstract class PQLEntity {
    private final String _pql;
    private PQLModifier _pqlModifier;

    public static String fixPQL(String pql) {
        while ((pql = pql.trim()).startsWith("(") && pql.endsWith(")")) {
            String subpql = pql.substring(1, pql.length() - 1);
            int parenthesisCount = 0;
            for (int i = 0; i < subpql.length(); ++i) {
                char c = subpql.charAt(i);
                if (c == '(') {
                    ++parenthesisCount;
                }
                if (c != ')') continue;
                if (parenthesisCount < 1) {
                    return pql.trim();
                }
                --parenthesisCount;
            }
            if (parenthesisCount > 0) {
                return pql.trim();
            }
            pql = subpql;
        }
        return pql.trim();
    }

    public static String removeModifierFromPQL(String pql) {
        String modifier = PQLEntity._getModifierFromPQL(pql = PQLEntity.fixPQL(pql));
        if (modifier != null) {
            pql = pql.substring(modifier.length());
        }
        return pql.trim();
    }

    public PQLEntity(String pql) throws Exception {
        if (pql != null) {
            pql = PQLEntity.fixPQL(pql);
            this._setModifierFromPQL(pql);
            pql = PQLEntity.removeModifierFromPQL(pql);
        }
        this._pql = pql;
    }

    public PQLModifier getPQLModifier() {
        return this._pqlModifier;
    }

    public abstract Object getPQLResult(Properties var1) throws Exception;

    protected String getPQL() {
        return this._pql;
    }

    private static String _getModifierFromPQL(String pql) {
        pql = PQLEntity.fixPQL(pql);
        Set<String> availableModifiers = PQLModifier.getAvailableModifiers();
        for (String modifier : availableModifiers) {
            if (!pql.startsWith(modifier)) continue;
            return modifier;
        }
        return null;
    }

    private void _setModifierFromPQL(String pql) throws Exception {
        String modifier = PQLEntity._getModifierFromPQL(pql = PQLEntity.fixPQL(pql));
        this._pqlModifier = modifier != null ? PQLModifierFactory.newPQLModifier(modifier) : null;
    }
}

