/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.source.formatter.check.BaseFileCheck;

public class JSONBatchEngineDataFileCheck
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws JSONException {
        if (!absolutePath.endsWith(".batch-engine-data.json")) {
            return content;
        }
        JSONObjectImpl jsonObject = new JSONObjectImpl(content);
        jsonObject.remove("actions");
        jsonObject.remove("facets");
        JSONObject configurationJSONObject = jsonObject.getJSONObject("configuration");
        if (configurationJSONObject != null) {
            configurationJSONObject.remove("companyId");
            boolean multiCompany = configurationJSONObject.getBoolean("multiCompany");
            if (!multiCompany) {
                configurationJSONObject.remove("multiCompany");
            }
            configurationJSONObject.remove("userId");
            configurationJSONObject.remove("version");
            jsonObject.put("configuration", configurationJSONObject);
        }
        return JSONUtil.toString(jsonObject);
    }
}

