/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.util.FileUtil;
import java.io.IOException;
import org.json.JSONObject;

public class JSONPackageJSONBNDVersionCheck
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        BNDSettings bndSettings;
        String bndReleaseVersion;
        if (!absolutePath.endsWith("/package.json") || !absolutePath.contains("/modules/apps/") && !absolutePath.contains("/modules/dxp/apps/") && !absolutePath.contains("/modules/private/apps/")) {
            return content;
        }
        JSONObject jsonObject = new JSONObject(content);
        if (jsonObject.isNull("version")) {
            return content;
        }
        int x = fileName.lastIndexOf("/");
        if (!FileUtil.exists(fileName.substring(0, x + 1) + "bnd.bnd")) {
            return content;
        }
        String version = jsonObject.getString("version");
        if (!version.equals(bndReleaseVersion = (bndSettings = this.getBNDSettings(fileName)).getReleaseVersion())) {
            return StringUtil.replaceFirst(content, "\"version\": \"" + version + "\"", "\"version\": \"" + bndReleaseVersion + "\"");
        }
        return content;
    }
}

