/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaTermStylingCheck
extends BaseJavaTermCheck {
    private static final Pattern _lineBreakPattern = Pattern.compile("\n(.*)\\(\n((.+,\n)*.*\\)) \\+\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        Matcher matcher = _lineBreakPattern.matcher(javaTerm.getContent());
        while (matcher.find()) {
            if (this.getLevel(matcher.group(2)) >= 0) continue;
            int pos = fileContent.indexOf(matcher.group()) + 1;
            this.addMessage(fileName, "Create a new var for \"" + StringUtil.trim(matcher.group(1)) + "\" for better readability", this.getLineNumber(fileContent, pos));
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CONSTRUCTOR, JAVA_METHOD};
    }
}

