/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertiesLiferayPluginPackageLiferayVersionsCheck
extends BaseFileCheck {
    private static final Pattern _liferayVersionsPattern = Pattern.compile("\nliferay-versions=(.*)\n");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (fileName.endsWith("/liferay-plugin-package.properties")) {
            return this._fixIncorrectLiferayVersions(absolutePath, content);
        }
        return content;
    }

    protected String getLiferayVersion(String absolutePath) throws Exception {
        return this.getPortalVersion(this.isModulesApp(absolutePath, true));
    }

    protected boolean isSkipFix(String absolutePath) {
        return !this.isModulesApp(absolutePath, false) || !this.isPortalSource();
    }

    private String _fixIncorrectLiferayVersions(String absolutePath, String content) throws Exception {
        if (this.isSkipFix(absolutePath)) {
            return content;
        }
        Matcher matcher = _liferayVersionsPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String liferayVersion = this.getLiferayVersion(absolutePath);
        if (Validator.isNull(liferayVersion)) {
            return content;
        }
        return StringUtil.replace(content, "liferay-versions=" + matcher.group(1), "liferay-versions=" + liferayVersion + "+", matcher.start());
    }
}

