/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJavaGetFileMethodCheck
extends BaseFileCheck {
    private static final Pattern _getFilePattern = Pattern.compile("(\\t+?\\s+?\\w*\\s*\\w+\\s*[^)]\\s+)(\\s*\\w+\\.getFile\\([^)]+\\))");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!fileName.endsWith(".java")) {
            return content;
        }
        List<String> importNames = JavaSourceUtil.getImportNames(content);
        if (!importNames.contains("com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil") && !importNames.contains("com.liferay.document.library.kernel.service.DLFileEntryLocalService")) {
            return content;
        }
        boolean replaced = false;
        Matcher matcher = _getFilePattern.matcher(content);
        while (matcher.find()) {
            String methodCall = matcher.group(2);
            if (methodCall.contains("DLFileEntryLocalServiceUtil") || this.hasClassOrVariableName("DLFileEntryLocalService", content, content, fileName, methodCall)) {
                content = this._formatMethodCall(content, methodCall, matcher.group(1));
            }
            replaced = true;
        }
        if (replaced) {
            content = JavaSourceUtil.addImports(content, "com.liferay.portal.kernel.util.FileUtil");
        }
        return content;
    }

    private String _formatMethodCall(String content, String methodCall, String variableName) {
        List<String> parameterNames = JavaSourceUtil.getParameterNames(methodCall);
        if (parameterNames.size() != 3) {
            return content;
        }
        return StringUtil.replace(content, variableName + methodCall, this._getNewMethodCall(methodCall, parameterNames, variableName));
    }

    private String _getNewMethodCall(String methodCall, List<String> parameterNames, String variableName) {
        StringBundler sb = new StringBundler(12);
        sb.append("\t");
        sb.append("\t");
        sb.append("InputStream inputStream = ");
        sb.append(this.getVariableName(methodCall));
        sb.append(".getFileAsStream(");
        sb.append(StringUtil.merge(parameterNames, ", "));
        sb.append(")");
        sb.append(";");
        sb.append("\n");
        sb.append("\n");
        sb.append(variableName);
        sb.append("FileUtil.createTempFile(inputStream)");
        return sb.toString();
    }
}

