/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseUpgradeVelocityMigrationCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeVelocityVariableReferenceMigrationCheck
extends BaseUpgradeVelocityMigrationCheck {
    private static final Pattern _variableReferencePattern = Pattern.compile("\\$[\\w\\.]+");

    @Override
    protected String migrateContent(String content) {
        String[] lines;
        String[] stringArray = lines = StringUtil.splitLines(content);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String line;
            String newLine = line = stringArray[i];
            Matcher matcher = _variableReferencePattern.matcher(line);
            while (matcher.find()) {
                String match = matcher.group();
                if (this._isJQuery(match)) continue;
                if (!this._isValidReplacement(newLine, match)) {
                    newLine = StringUtil.replace(newLine, match, StringUtil.removeChar(match, '$'));
                    continue;
                }
                int beginCharIndex = newLine.indexOf(match) + match.length();
                if (newLine.length() > beginCharIndex && newLine.charAt(beginCharIndex) == '(') {
                    newLine = UpgradeVelocityVariableReferenceMigrationCheck._encapsulateMethodCall(newLine, match, beginCharIndex);
                    continue;
                }
                String startNewMatch = StringUtil.replace(match, '$', "${");
                newLine = StringUtil.replace(newLine, match, startNewMatch + '}');
            }
            content = StringUtil.replace(content, line, newLine);
        }
        return content;
    }

    private static String _encapsulateMethodCall(String newLine, String match, int beginCharIndex) {
        boolean newMethodCall = false;
        int parenthesisStack = 0;
        String endLine = newLine.substring(beginCharIndex);
        for (int i = 0; i < endLine.length(); ++i) {
            int nextCharIndex = beginCharIndex + i;
            if (newLine.charAt(nextCharIndex) == '(') {
                ++parenthesisStack;
            } else if (newLine.charAt(nextCharIndex) == ')') {
                --parenthesisStack;
                newMethodCall = false;
                if (newLine.length() > nextCharIndex + 1 && newLine.charAt(nextCharIndex + 1) == '.') {
                    newMethodCall = true;
                }
            }
            if (parenthesisStack != 0 || newMethodCall) continue;
            String endMatch = newLine.substring(beginCharIndex, nextCharIndex + 1);
            String fullMatch = match + endMatch;
            String newReference = StringUtil.replace(match, '$', "${");
            newLine = StringUtil.replaceFirst(newLine, fullMatch, newReference + endMatch + '}');
            break;
        }
        return newLine;
    }

    private static boolean _isAttribute(String line, String match) {
        boolean attribute = false;
        int initMatchIndex = line.indexOf(match);
        String afterMatch = line.substring(initMatchIndex + match.length());
        String beforeMatch = line.substring(0, initMatchIndex);
        for (int i = 1; i < beforeMatch.length() + 1; ++i) {
            int previousCharIndex = initMatchIndex - i;
            if (line.charAt(previousCharIndex) == '\"' && StringUtil.count(afterMatch, '\"') % 2 != 0) {
                attribute = true;
                break;
            }
            if (line.charAt(previousCharIndex) != '\'' || StringUtil.count(afterMatch, '\'') % 2 == 0) continue;
            attribute = true;
            break;
        }
        return attribute;
    }

    private boolean _isJQuery(String match) {
        return match.charAt(1) == '(' || match.charAt(1) == '.';
    }

    private boolean _isValidReplacement(String line, String match) {
        boolean validReplacement = true;
        String lineBegin = (line = StringUtil.removeChars(line, ' ', '\t')).substring(0, 2);
        if ((lineBegin.equals("<#") || lineBegin.equals("<@") || line.charAt(0) == '#') && !UpgradeVelocityVariableReferenceMigrationCheck._isAttribute(line, match)) {
            validReplacement = false;
        }
        if (line.charAt(0) != '<' && !UpgradeVelocityVariableReferenceMigrationCheck._isAttribute(line, match) && StringUtil.count(line, '(') != StringUtil.count(line, ')')) {
            validReplacement = false;
        }
        return validReplacement;
    }
}

