/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.source.formatter.checkstyle.check.BaseUnnecessaryStatementCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class UnnecessaryAssignCheck
extends BaseUnnecessaryStatementCheck {
    private static final String _MSG_UNNECESSARY_ASSIGN_BEFORE_REASSIGN = "assign.unnecessary.before.reassign";
    private static final String _MSG_UNNECESSARY_ASSIGN_BEFORE_RETURN = "assign.unnecessary.before.return";
    private static final String _MSG_UNNECESSARY_ASSIGN_UNUSED = "assign.unnecessary.unused";
    private static final String _MSG_UNNECESSARY_LIST_ASSIGN_BEFORE_RETURN = "list.assign.unnecessary.before.return";
    private static final String _MSG_UNNECESSARY_TO_STRING = "assign.unnecessary.to.string";

    public int[] getDefaultTokens() {
        return new int[]{80};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST ancestorDetailAST;
        DetailAST variableDefinitionDetailAST;
        List<DetailAST> variableCallerDetailASTList;
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST.getType() != 28) {
            return;
        }
        DetailAST slistDetailAST = parentDetailAST.getParent();
        if (slistDetailAST.getType() != 7) {
            return;
        }
        DetailAST semiDetailAST = parentDetailAST.getNextSibling();
        if (semiDetailAST == null || semiDetailAST.getType() != 45) {
            return;
        }
        DetailAST firstChildDetailAST = detailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 58) {
            return;
        }
        String variableName = firstChildDetailAST.getText();
        DetailAST variableTypeDetailAST = this.getVariableTypeDetailAST(detailAST, variableName, false);
        if (variableTypeDetailAST == null) {
            return;
        }
        if (!this._hasPrecedingAssignStatement(parentDetailAST, variableName) && !this._isUsedInFinallyStatement(detailAST, variableName)) {
            if (!this.isExcludedPath("run.outside.portal.excludes")) {
                this.checkUnnecessaryListVariableBeforeReturn(detailAST, semiDetailAST, variableName, _MSG_UNNECESSARY_LIST_ASSIGN_BEFORE_RETURN);
            }
            this.checkUnnecessaryStatementBeforeReturn(detailAST, semiDetailAST, variableName, _MSG_UNNECESSARY_ASSIGN_BEFORE_RETURN);
        }
        if ((variableCallerDetailASTList = this.getVariableCallerDetailASTList(variableDefinitionDetailAST = variableTypeDetailAST.getParent(), variableName)).isEmpty()) {
            return;
        }
        this.checkUnnecessaryToString(detailAST, _MSG_UNNECESSARY_TO_STRING);
        DetailAST firstNextVariableCallerDetailAST = null;
        DetailAST secondNextVariableCallerDetailAST = null;
        int endLineNumber = this.getEndLineNumber(detailAST);
        for (int i = 0; i < variableCallerDetailASTList.size(); ++i) {
            DetailAST variableCallerDetailAST = variableCallerDetailASTList.get(i);
            if (variableCallerDetailAST.getLineNo() <= endLineNumber) continue;
            firstNextVariableCallerDetailAST = variableCallerDetailAST;
            if (i >= variableCallerDetailASTList.size() - 1) break;
            secondNextVariableCallerDetailAST = variableCallerDetailASTList.get(i + 1);
            break;
        }
        if (firstNextVariableCallerDetailAST != null) {
            this.checkUnnecessaryStatementBeforeReassign(detailAST, firstNextVariableCallerDetailAST, secondNextVariableCallerDetailAST, slistDetailAST, variableName, _MSG_UNNECESSARY_ASSIGN_BEFORE_REASSIGN);
            return;
        }
        DetailAST lastChildDetailAST = detailAST.getLastChild();
        if (lastChildDetailAST.getType() == 135) {
            return;
        }
        parentDetailAST = variableDefinitionDetailAST.getParent();
        if (parentDetailAST.getType() != 156 && parentDetailAST.getType() != 7) {
            return;
        }
        if (firstNextVariableCallerDetailAST == null && (ancestorDetailAST = this.getParentWithTokenType(detailAST, 91, 84, 6)).getLineNo() <= variableDefinitionDetailAST.getLineNo()) {
            this.log(detailAST, _MSG_UNNECESSARY_ASSIGN_UNUSED, new Object[]{variableName});
        }
    }

    private boolean _hasPrecedingAssignStatement(DetailAST detailAST, String variableName) {
        DetailAST previousDetailAST = detailAST.getPreviousSibling();
        if (previousDetailAST == null || previousDetailAST.getType() != 45) {
            return false;
        }
        if ((previousDetailAST = previousDetailAST.getPreviousSibling()).getType() != 28) {
            return false;
        }
        DetailAST firstChildDetailAST = previousDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() != 80) {
            return false;
        }
        return variableName.equals((firstChildDetailAST = firstChildDetailAST.getFirstChild()).getText());
    }

    private boolean _isUsedInFinallyStatement(DetailAST detailAST, String variableName) {
        List<String> names;
        DetailAST literalFinallyDetailAST;
        DetailAST parentDetailAST = detailAST;
        do {
            if ((parentDetailAST = this.getParentWithTokenType(parentDetailAST, 95)) != null) continue;
            return false;
        } while ((literalFinallyDetailAST = parentDetailAST.findFirstToken(97)) == null || !(names = this.getNames(literalFinallyDetailAST, true)).contains(variableName));
        return true;
    }
}

