/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UnnecessaryMethodCallCheck
extends BaseCheck {
    private static final String _MSG_UNNECESSARY_METHOD_CALL = "method.call.unnecessary";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        Map<String, String> returnVariableNamesMap = this._getReturnVariableNamesMap(detailAST);
        if (returnVariableNamesMap.isEmpty()) {
            return;
        }
        List<DetailAST> methodCallDetailASTList = this.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallDetailAST : methodCallDetailASTList) {
            String replacementValue;
            String methodName;
            DetailAST dotDetailAST = methodCallDetailAST.findFirstToken(59);
            if (dotDetailAST != null) continue;
            DetailAST elistDetailAST = methodCallDetailAST.findFirstToken(34);
            List<DetailAST> exprDetailASTList = this.getAllChildTokens(elistDetailAST, false, 28);
            if (!exprDetailASTList.isEmpty() || !returnVariableNamesMap.containsKey(methodName = this.getName(methodCallDetailAST))) continue;
            DetailAST parentDetailAST = methodCallDetailAST.getParent();
            while (parentDetailAST.getType() != 14) {
                parentDetailAST = parentDetailAST.getParent();
            }
            if (!parentDetailAST.equals(detailAST) || (replacementValue = this._getReplacementValue(methodCallDetailAST, returnVariableNamesMap.get(methodName))) == null) continue;
            this.log(methodCallDetailAST, _MSG_UNNECESSARY_METHOD_CALL, new Object[]{replacementValue, methodName});
        }
    }

    private String _getReplacementValue(DetailAST methodCallDetailAST, String variableName) {
        DetailAST previousDetailAST = methodCallDetailAST.getParent();
        while (!(previousDetailAST.getType() == 9 || previousDetailAST.getType() == 8 || previousDetailAST.getType() == 10 && (previousDetailAST.branchContains(61) || previousDetailAST.branchContains(63) || previousDetailAST.branchContains(62)))) {
            previousDetailAST = previousDetailAST.getParent();
        }
        List<DetailAST> variableDefDetailASTList = this.getAllChildTokens(previousDetailAST, true, 10);
        for (DetailAST variableDefDetailAST : variableDefDetailASTList) {
            DetailAST nameDetailAST = variableDefDetailAST.findFirstToken(58);
            if (!Objects.equals(nameDetailAST.getText(), variableName)) continue;
            DetailAST modifiersDetailAST = previousDetailAST.findFirstToken(5);
            if (modifiersDetailAST.branchContains(64)) {
                return null;
            }
            if (variableDefDetailAST.getLineNo() <= methodCallDetailAST.getLineNo()) {
                return "this." + variableName;
            }
            return variableName;
        }
        return variableName;
    }

    private Map<String, String> _getReturnVariableNamesMap(DetailAST detailAST) {
        HashMap<String, String> returnVariableNamesMap = new HashMap<String, String>();
        DetailAST objBlockDetailAST = detailAST.findFirstToken(6);
        if (objBlockDetailAST == null) {
            return returnVariableNamesMap;
        }
        List<DetailAST> methodDefinitionDetailASTList = this.getAllChildTokens(objBlockDetailAST, false, 9);
        for (DetailAST methodDefinitionDetailAST : methodDefinitionDetailASTList) {
            DetailAST nextSiblingDetailAST;
            DetailAST firstChildDetailAST;
            DetailAST slistDetailAST;
            List<DetailAST> parameterDefs;
            if (!methodDefinitionDetailAST.branchContains(61) && !methodDefinitionDetailAST.branchContains(64) || !(parameterDefs = this.getParameterDefs(methodDefinitionDetailAST)).isEmpty() || (slistDetailAST = methodDefinitionDetailAST.findFirstToken(7)) == null || (firstChildDetailAST = slistDetailAST.getFirstChild()) == null || firstChildDetailAST.getType() != 88 || (firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() != 28 || (nextSiblingDetailAST = firstChildDetailAST.getNextSibling()) == null || nextSiblingDetailAST.getType() != 45 || (firstChildDetailAST = firstChildDetailAST.getFirstChild()).getType() != 58) continue;
            returnVariableNamesMap.put(this.getName(methodDefinitionDetailAST), firstChildDetailAST.getText());
        }
        return returnVariableNamesMap;
    }
}

