/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseEmptyLinesCheck;
import com.liferay.source.formatter.check.util.XMLSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLEmptyLinesCheck
extends BaseEmptyLinesCheck {
    private static final Pattern _emptyLineBetweenTagsPattern = Pattern.compile("\n(\t*)<[\\w/].*[^-]>(\n\n)(\t*)<(\\w)");
    private static final Pattern _emptyLineInTagPattern1 = Pattern.compile(">\n\n\t*+(?!<)");
    private static final Pattern _emptyLineInTagPattern2 = Pattern.compile("\n\n\t+</(.+)>");
    private static final Pattern _missingEmptyLineAfterCommentPattern = Pattern.compile("[\t ]-->\n[\t<]");
    private static final Pattern _missingEmptyLineBeforeCommentPattern = Pattern.compile(">\n\t+<!--[\n ]");
    private static final Pattern _redundantEmptyLinePattern = Pattern.compile("<\\?xml .*\\?>\n\n<\\!DOCTYPE");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.matches(".*\\.(action|function|macro|testcase)") || fileName.endsWith("/content.xml")) {
            return content;
        }
        content = this.fixEmptyLinesInMultiLineTags(content);
        content = this.fixEmptyLinesInNestedTags(content);
        content = this.fixMissingEmptyLineAfterDoctype(content);
        content = this._fixEmptyLinesBetweenTags(fileName, content);
        content = this._fixEmptyLinesInTag(content);
        Matcher matcher = _redundantEmptyLinePattern.matcher(content = this._fixMissingEmptyLinesAroundComments(content));
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.start());
        }
        return content;
    }

    private String _fixEmptyLinesBetweenTags(String fileName, String content) {
        if (fileName.startsWith(this.getBaseDirName() + "build") || fileName.matches(".*/(build|tools/).*")) {
            return content;
        }
        if (fileName.endsWith("-log4j-ext.xml") || fileName.endsWith("-log4j.xml") || fileName.endsWith("-logback.xml") || fileName.endsWith("/ivy.xml") || fileName.endsWith("/struts-config.xml") || fileName.endsWith("/tiles-defs.xml")) {
            return this.fixEmptyLinesBetweenTags(content);
        }
        Matcher matcher = _emptyLineBetweenTagsPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.end(1));
        }
        return content;
    }

    private String _fixEmptyLinesInTag(String content) {
        Matcher matcher = _emptyLineInTagPattern1.matcher(content);
        while (matcher.find()) {
            String trimmedLine = StringUtil.trimLeading(this.getLine(content, this.getLineNumber(content, matcher.start())));
            if (trimmedLine.startsWith("<content") || trimmedLine.startsWith("<echo") || XMLSourceUtil.isInsideCDATAMarkup(content, matcher.start())) continue;
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.start());
        }
        matcher = _emptyLineInTagPattern2.matcher(content);
        while (matcher.find()) {
            String trimmedLine;
            String tagName = matcher.group(1);
            if (tagName.startsWith("content") || tagName.startsWith("echo") || (trimmedLine = StringUtil.trim(this.getLine(content, this.getLineNumber(content, matcher.start())))).startsWith("<") || trimmedLine.endsWith(">") || XMLSourceUtil.isInsideCDATAMarkup(content, matcher.start())) continue;
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.start());
        }
        return content;
    }

    private String _fixMissingEmptyLinesAroundComments(String content) {
        Matcher matcher = _missingEmptyLineAfterCommentPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "-->\n", "-->\n\n", matcher.start());
        }
        matcher = _missingEmptyLineBeforeCommentPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, ">\n", ">\n\n", matcher.start());
        }
        return content;
    }
}

