/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.liferay.source.formatter.util.FileUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class GenericTypeCheck
extends BaseCheck {
    private static final String _GENERIC_TYPE_NAMES_CATEGORY = "genericTypeNames";
    private static final String _GENERIC_TYPE_NAMES_FILE_NAME = "generic-type-names.json";
    private static final String[] _JAVA_LANG_INTERFACE_NAMES = new String[]{"Appendable", "AutoCloseable", "CharSequence", "Cloneable", "Comparable", "Iterable", "Readable", "Runnable"};
    private static final String _MSG_PARAMETERIZE_GENERIC_TYPE = "generic.type.parameterize";
    private static final String _POPULATE_TYPE_NAMES_KEY = "populateTypeNames";
    private static final Log _log = LogFactoryUtil.getLog(GenericTypeCheck.class);
    private Map<String, Integer> _genericTypeNamesMap;
    private Tuple _genericTypeNamesTuple;

    public int[] getDefaultTokens() {
        return new int[]{18, 19, 9, 21, 10};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        if (detailAST.getType() == 18 || detailAST.getType() == 19) {
            List<DetailAST> childDetailASTList = this.getAllChildTokens(detailAST, false, 59, 58);
            for (DetailAST childDetailAST : childDetailASTList) {
                this._checkType(detailAST, childDetailAST);
            }
        }
        this._checkType(detailAST, detailAST.findFirstToken(13));
    }

    private void _checkType(DetailAST detailAST, DetailAST childDetailAST) {
        DetailAST parentDetailAST;
        if (childDetailAST == null || detailAST.findFirstToken(171) != null) {
            return;
        }
        DetailAST typeArgumentsDetailAST = this.getTypeArgumentsDetailAST(childDetailAST);
        if (typeArgumentsDetailAST != null) {
            List<DetailAST> typeArgumentDetailASTList = this.getAllChildTokens(typeArgumentsDetailAST, false, 164);
            if (this.isAttributeValue(_POPULATE_TYPE_NAMES_KEY)) {
                this._populateGenericTypeNames(childDetailAST, typeArgumentDetailASTList);
            }
            for (DetailAST typeArgumentDetailAST : typeArgumentDetailASTList) {
                this._checkType(detailAST, typeArgumentDetailAST);
            }
            return;
        }
        String genericTypeName = this._getGenericTypeName(childDetailAST);
        if (genericTypeName == null) {
            return;
        }
        if (!genericTypeName.startsWith("com.liferay.")) {
            if (detailAST.getType() == 9 && this._overridesUnknownTerm(detailAST)) {
                return;
            }
            if (detailAST.getType() == 21 && (parentDetailAST = this.getParentWithTokenType(detailAST, 9, 8)) != null && this._overridesUnknownTerm(parentDetailAST)) {
                return;
            }
        }
        for (parentDetailAST = childDetailAST; parentDetailAST != null; parentDetailAST = parentDetailAST.getParent()) {
            if (!this._hasSuppressWarningsAnnotation(parentDetailAST, "rawtypes")) continue;
            return;
        }
        Map<String, Integer> genericTypeNamesMap = this._getGenericTypeNamesMap();
        int genericTypeCount = GetterUtil.getInteger(genericTypeNamesMap.get(genericTypeName));
        if (genericTypeCount == 1) {
            this.log(childDetailAST, _MSG_PARAMETERIZE_GENERIC_TYPE, new Object[]{"type", genericTypeName});
        } else {
            this.log(childDetailAST, _MSG_PARAMETERIZE_GENERIC_TYPE, new Object[]{"types", genericTypeName});
        }
    }

    private String _getGenericTypeName(DetailAST detailAST) {
        Map<String, Integer> genericTypeNamesMap = this._getGenericTypeNamesMap();
        String typeName = this._getTypeName(detailAST);
        String fullyQualifiedTypeName = this.getFullyQualifiedTypeName(typeName, detailAST, false);
        if (fullyQualifiedTypeName != null && genericTypeNamesMap.containsKey(fullyQualifiedTypeName)) {
            return fullyQualifiedTypeName;
        }
        if (typeName.equals(fullyQualifiedTypeName)) {
            return null;
        }
        if (genericTypeNamesMap.containsKey("java.lang." + typeName)) {
            return "java.lang." + typeName;
        }
        FileContents fileContents = this.getFileContents();
        FileText fileText = fileContents.getText();
        typeName = JavaSourceUtil.getPackageName((String)fileText.getFullText()) + "." + typeName;
        if (genericTypeNamesMap.containsKey(typeName)) {
            return typeName;
        }
        return null;
    }

    private synchronized Map<String, Integer> _getGenericTypeNamesMap() {
        if (this._genericTypeNamesMap != null) {
            return this._genericTypeNamesMap;
        }
        Tuple genericTypeNamesTuple = this._getGenericTypeNamesTuple();
        JSONObject jsonObject = (JSONObject)genericTypeNamesTuple.getObject(0);
        JSONArray jsonArray = (JSONArray)jsonObject.get(_GENERIC_TYPE_NAMES_CATEGORY);
        this._genericTypeNamesMap = new TreeMap<String, Integer>();
        for (Object object : JSONUtil.toObjectList(jsonArray)) {
            jsonObject = (JSONObject)object;
            this._genericTypeNamesMap.put(jsonObject.getString("name"), jsonObject.getInt("genericTypeCount"));
        }
        return this._genericTypeNamesMap;
    }

    private synchronized Tuple _getGenericTypeNamesTuple() {
        if (this._genericTypeNamesTuple != null) {
            return this._genericTypeNamesTuple;
        }
        this._genericTypeNamesTuple = this.getTypeNamesTuple(_GENERIC_TYPE_NAMES_FILE_NAME, _GENERIC_TYPE_NAMES_CATEGORY);
        return this._genericTypeNamesTuple;
    }

    private String _getTypeName(DetailAST detailAST) {
        if (detailAST.getType() == 13 || detailAST.getType() == 164) {
            return this.getTypeName(detailAST, false);
        }
        if (detailAST.getType() == 59) {
            FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)detailAST);
            return fullIdent.getText();
        }
        return detailAST.getText();
    }

    private boolean _hasSuppressWarningsAnnotation(DetailAST detailAST, String warning) {
        DetailAST modifiersDetailAST = detailAST.findFirstToken(5);
        if (modifiersDetailAST == null) {
            return false;
        }
        DetailAST annotationDetailAST = AnnotationUtil.getAnnotation((DetailAST)detailAST, (String)"SuppressWarnings");
        if (annotationDetailAST == null) {
            return false;
        }
        List<DetailAST> literalStringDetailASTList = this.getAllChildTokens(annotationDetailAST, true, 139);
        for (DetailAST literalStringDetailAST : literalStringDetailASTList) {
            String s = literalStringDetailAST.getText();
            if (!s.equals("\"" + warning + "\"")) continue;
            return true;
        }
        return false;
    }

    private boolean _overridesUnknownTerm(DetailAST detailAST) {
        if (!AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Override")) {
            return false;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if ((parentDetailAST = parentDetailAST.getParent()).getType() != 14 || parentDetailAST.findFirstToken(18) != null) {
            return true;
        }
        DetailAST implementsClauseDetailAST = parentDetailAST.findFirstToken(19);
        if (implementsClauseDetailAST == null) {
            return false;
        }
        List<String> importNames = this.getImportNames(detailAST);
        DetailAST childDetailAST = implementsClauseDetailAST.getFirstChild();
        while (childDetailAST != null) {
            FullIdent fullIdent;
            String implementedClassName;
            if (childDetailAST.getType() == 58) {
                String implementedClassName2 = childDetailAST.getText();
                if (ArrayUtil.contains(_JAVA_LANG_INTERFACE_NAMES, implementedClassName2)) {
                    return true;
                }
                for (String importName : importNames) {
                    if (!importName.endsWith("." + implementedClassName2)) continue;
                    if (!importName.startsWith("com.liferay.")) {
                        return true;
                    }
                    break;
                }
            } else if (childDetailAST.getType() == 59 && !(implementedClassName = (fullIdent = FullIdent.createFullIdent((DetailAST)childDetailAST)).getText()).startsWith("com.liferay.")) {
                return true;
            }
            childDetailAST = childDetailAST.getNextSibling();
        }
        return false;
    }

    private void _populateGenericTypeNames(DetailAST childDetailAST, List<DetailAST> typeArgumentDetailASTList) {
        block7: {
            Tuple genericTypeNamesTuple = this._getGenericTypeNamesTuple();
            File genericTypeNamesFile = (File)genericTypeNamesTuple.getObject(1);
            if (genericTypeNamesFile == null) {
                return;
            }
            for (DetailAST typeArgumentDetailAST : typeArgumentDetailASTList) {
                String name;
                DetailAST firstChildDetailAST = typeArgumentDetailAST.getFirstChild();
                if (firstChildDetailAST.getType() == 167) {
                    return;
                }
                if (firstChildDetailAST.getType() != 58 || (name = firstChildDetailAST.getText()).length() != 1) continue;
                return;
            }
            Map<String, Integer> genericTypeNamesMap = this._getGenericTypeNamesMap();
            String fullyQualifiedTypeName = this.getFullyQualifiedTypeName(this._getTypeName(childDetailAST), childDetailAST, false);
            if (fullyQualifiedTypeName == null || genericTypeNamesMap.containsKey(fullyQualifiedTypeName)) {
                return;
            }
            genericTypeNamesMap.put(fullyQualifiedTypeName, typeArgumentDetailASTList.size());
            try {
                JSONObjectImpl jsonObject = new JSONObjectImpl();
                JSONArrayImpl jsonArray = new JSONArrayImpl();
                for (Map.Entry<String, Integer> entry : genericTypeNamesMap.entrySet()) {
                    JSONObjectImpl curJSONObject = new JSONObjectImpl();
                    curJSONObject.put("genericTypeCount", entry.getValue()).put("name", entry.getKey());
                    jsonArray.put(curJSONObject);
                }
                jsonObject.put(_GENERIC_TYPE_NAMES_CATEGORY, jsonArray);
                FileUtil.write(genericTypeNamesFile, JSONUtil.toString(jsonObject));
                System.out.println(StringBundler.concat("Added \"", fullyQualifiedTypeName, "\" to \"", _GENERIC_TYPE_NAMES_FILE_NAME, "\""));
                this._genericTypeNamesMap = null;
                this._genericTypeNamesTuple = null;
            }
            catch (IOException ioException) {
                if (!_log.isDebugEnabled()) break block7;
                _log.debug(ioException);
            }
        }
    }
}

