/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.HashSet;
import java.util.List;

public class OSGiCommandsCheck
extends BaseCheck {
    private static final String _MSG_BAD_CLASS_NAME = "bad.class.name";
    private static final String _MSG_BAD_OSGI_REFERENCE = "bad.osgi.reference";
    private static final String _MSG_MISSING_COMMAND_FUNCTION = "missing.command.function";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        List<String> importNames = this.getImportNames(detailAST);
        if (!importNames.contains("org.osgi.service.component.annotations.Component")) {
            return;
        }
        this._checkClassDeclaration(detailAST);
        if (!importNames.contains("org.osgi.service.component.annotations.Reference")) {
            return;
        }
        for (DetailAST variableDefinitionDetailAST : this.getAllChildTokens(detailAST, true, 10)) {
            this._checkVariableDeclaration(variableDefinitionDetailAST);
        }
    }

    private void _checkClassDeclaration(DetailAST detailAST) {
        DetailAST annotationDetailAST = AnnotationUtil.getAnnotation((DetailAST)detailAST, (String)"Component");
        if (annotationDetailAST == null) {
            return;
        }
        DetailAST annotationMemberValuePairDetailAST = this.getAnnotationMemberValuePairDetailAST(annotationDetailAST, "property");
        if (annotationMemberValuePairDetailAST == null) {
            return;
        }
        DetailAST annotationArrayInitDetailAST = annotationMemberValuePairDetailAST.findFirstToken(162);
        if (annotationArrayInitDetailAST == null) {
            return;
        }
        boolean osgiCommandsClass = false;
        HashSet<String> osgiCommandFunctions = new HashSet<String>();
        for (DetailAST expressionDetailAST : this.getAllChildTokens(annotationArrayInitDetailAST, false, 28)) {
            String[] property;
            DetailAST firstChildDetailAST = expressionDetailAST.getFirstChild();
            if (firstChildDetailAST.getType() != 139 || !(property = StringUtil.split(StringUtil.unquote(firstChildDetailAST.getText()), '='))[0].equals("osgi.command.function")) continue;
            osgiCommandsClass = true;
            osgiCommandFunctions.add(property[1]);
        }
        if (!osgiCommandsClass) {
            return;
        }
        String className = this.getName(detailAST);
        if (!className.endsWith("OSGiCommands")) {
            this.log(detailAST, _MSG_BAD_CLASS_NAME, new Object[0]);
        }
        for (DetailAST methodDefinitionDetailAST : this.getAllChildTokens(detailAST, true, 9)) {
            osgiCommandFunctions.remove(this.getName(methodDefinitionDetailAST));
        }
        for (String osgiCommandFunction : osgiCommandFunctions) {
            this.log(detailAST, _MSG_MISSING_COMMAND_FUNCTION, new Object[]{osgiCommandFunction});
        }
    }

    private void _checkVariableDeclaration(DetailAST detailAST) {
        if (!AnnotationUtil.containsAnnotation((DetailAST)detailAST, (String)"Reference")) {
            return;
        }
        String typeName = this.getTypeName(detailAST, false);
        if (typeName.endsWith("OSGiCommands")) {
            this.log(detailAST, _MSG_BAD_OSGI_REFERENCE, new Object[0]);
        }
    }
}

