/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.io.unsync;

import com.liferay.petra.io.unsync.UnsyncFilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class UnsyncBufferedOutputStream
extends UnsyncFilterOutputStream {
    private static final int _DEFAULT_BUFFER_SIZE = 8192;
    private byte[] _buffer;
    private int _count;

    public UnsyncBufferedOutputStream(OutputStream outputStream) {
        this(outputStream, 8192);
    }

    public UnsyncBufferedOutputStream(OutputStream outputStream, int size) {
        super(outputStream);
        if (size <= 0) {
            throw new IllegalArgumentException("Size is less than 1");
        }
        this._buffer = new byte[size];
    }

    @Override
    public void flush() throws IOException {
        this._flushBuffer();
        this.outputStream.flush();
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        if (length >= this._buffer.length) {
            this._flushBuffer();
            this.outputStream.write(bytes, offset, length);
            return;
        }
        if (length > this._buffer.length - this._count) {
            this._flushBuffer();
        }
        System.arraycopy(bytes, offset, this._buffer, this._count, length);
        this._count += length;
    }

    @Override
    public void write(int b) throws IOException {
        if (this._count >= this._buffer.length) {
            this.outputStream.write(this._buffer, 0, this._count);
            this._count = 0;
        }
        this._buffer[this._count++] = (byte)b;
    }

    private void _flushBuffer() throws IOException {
        if (this._count > 0) {
            this.outputStream.write(this._buffer, 0, this._count);
            this._count = 0;
        }
    }
}

