/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.GradleSourceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleTestDependencyVersionCheck
extends BaseFileCheck {
    private static final String _ALLOWED_DEPENDENCY_NAMES_KEY = "allowedDependencyNames";
    private static final Pattern _dependenciesPattern = Pattern.compile("(\n|\\A)(\t*)dependencies \\{\n");
    private static final Pattern _dependencyNamePattern = Pattern.compile(".*, name: \"([^\"]*)\".*");
    private static final Pattern _dependencyVersionPattern = Pattern.compile(".*, version: \"([^\"]*)\".*");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!(absolutePath.contains("/modules/apps/") || absolutePath.contains("/modules/dxp/apps/") || absolutePath.contains("/modules/private/apps/"))) {
            return content;
        }
        for (String dependencies : this._getDependenciesBlocks(content)) {
            content = this._formatDependencies(fileName, absolutePath, content, dependencies);
        }
        return content;
    }

    private String _formatDependencies(String fileName, String absolutePath, String content, String dependencies) {
        int y;
        int x = dependencies.indexOf("\n");
        if (x == (y = dependencies.lastIndexOf("\n"))) {
            return content;
        }
        List<String> allowedDependencyNames = this.getAttributeValues(_ALLOWED_DEPENDENCY_NAMES_KEY, absolutePath);
        dependencies = dependencies.substring(x, y + 1);
        StringBundler sb = new StringBundler();
        for (String line : StringUtil.splitLines(dependencies)) {
            if (!StringUtil.startsWith(GradleSourceUtil.getConfiguration(StringUtil.trim(line)), "test")) {
                sb.append(line);
                sb.append("\n");
                continue;
            }
            String dependencyName = this._getDependencyName(line);
            if (dependencyName.equals("com.liferay.portal.impl") || dependencyName.equals("com.liferay.portal.kernel") || dependencyName.equals("com.liferay.portal.test") || dependencyName.equals("com.liferay.portal.test.integration") || dependencyName.equals("com.liferay.util.bridges") || dependencyName.equals("com.liferay.util.java") || dependencyName.equals("com.liferay.util.taglib")) {
                String dependencyVersion = this._getDependencyVersion(line);
                if (dependencyVersion.equals("default")) {
                    sb.append(line);
                } else {
                    String newLine = StringUtil.replaceFirst(line, "version: \"" + dependencyVersion + "\"", "version: \"default\"");
                    sb.append(newLine);
                }
                sb.append("\n");
                continue;
            }
            if (!(!dependencyName.startsWith("com.liferay.") || dependencyName.startsWith("com.liferay.jakarta") || dependencyName.startsWith("com.liferay.portletmvc4spring") || line.contains("project(\"") || allowedDependencyNames.contains(dependencyName))) {
                this.addMessage(fileName, "Use a project dependency instead of a module dependency", this.getLineNumber(content, content.indexOf(line)));
            }
            sb.append(line);
            sb.append("\n");
        }
        return StringUtil.replace(content, StringUtil.trim(dependencies), StringUtil.trim(sb.toString()));
    }

    private List<String> _getDependenciesBlocks(String content) {
        ArrayList<String> dependenciesBlocks = new ArrayList<String>();
        Matcher matcher = _dependenciesPattern.matcher(content);
        while (matcher.find()) {
            String dependencies;
            int level;
            int y = matcher.start();
            do {
                if ((y = content.indexOf("}", y + 1)) != -1) continue;
                return dependenciesBlocks;
            } while ((level = this.getLevel(dependencies = content.substring(matcher.start(2), y + 1), "{", "}")) != 0);
            if (dependencies.contains("}\n")) continue;
            dependenciesBlocks.add(dependencies);
        }
        return dependenciesBlocks;
    }

    private String _getDependencyName(String dependency) {
        Matcher matcher = _dependencyNamePattern.matcher(dependency);
        if (!matcher.find()) {
            return "";
        }
        return matcher.group(1);
    }

    private String _getDependencyVersion(String dependency) {
        Matcher matcher = _dependencyVersionPattern.matcher(dependency);
        if (!matcher.find()) {
            return "";
        }
        return matcher.group(1);
    }
}

